/* ccgo: nc/map.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef NC_MAP_HH
#define NC_MAP_HH
#include <nc/nc.hh>
#include <ui/map.hh>
#include <string>
namespace nc {
	class Map :
		public ui::Map
	{
		Nc * nc;

		bool shown;

		// window geometry
		int win_x;
		int win_y;
		int win_w;
		int win_h;

		// cursor
		int cur_x;
		int cur_y;
		char cur_left;
		char cur_right;

		// implementation override
		void do_update();
	public:
		Map();
		void set_nc(Nc * n);

		static unsigned get_width();
		static unsigned get_min_h();

		// actually allocated geometry
		void set_window(int x, int y, int w, int h);
	private:
		void draw();
	};
}
#endif // NC_MAP_HH
