/* ccgo: nc/map.cc
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <nc/map.hh>
#include <nc/misc.hh>
#include <go/game.hh>
#include <debug.hh>
#include <sstream>
#include <iomanip>

using namespace nc;
using namespace std;

void Map::do_update()
{
	draw();
}

Map::Map() :
	nc(0),
	shown(false)
{
}

void Map::set_nc(Nc * n)
{
	nc = n;
}


unsigned Map::get_width()
{
	return 9;
}

unsigned Map::get_min_h()
{
	return 1;
}

void Map::set_window(int x, int y, int w, int h)
{
	assert(nc);
	win_x = x;
	win_y = y;
	win_w = w;
	win_h = h;
	shown = w >= int(get_width()) && h >= int(get_min_h());
	draw();
}

void Map::draw()
{
	if (! shown) return;
	if (! where()) {
		for (int y = 0; y < win_h; y ++) nc->draw_text(win_x, win_y + y, "         ");
		return;
	}
	unsigned sz = where()->get_game()->get_init().get_size();
	unsigned l = win_h;
	unsigned c = where()->get_level(); // current level
	// find last node
	unsigned k = path_max_level();
	// starting level
	unsigned s = k < l || c < l / 2 ? 0 : c + l > k + l / 2 + 1 ? k + 1 - l : c - l / 2;
	for (unsigned i = 0; i < l; i ++) {
		ostringstream t;
		if (s + i <= path_max_level()) {
			go::Node * n = path(s + i);
			bool a1 = false; // alternative 1
			bool a2 = false; // alternative 2
			if (s + i) {
				unsigned j = n->get_order();
				if (j > 0) a1 = true;
				if (j + 1 < n->up()->down().size()) a2 = true;
			}
			t << (s + i == c ? '[' : ' ');
			t << (a1 ? '<' : ' ');
			go::Move m = n->get_move();
			if (s + i) {
				if (m == go::MoveNone) {
					t << "  |  "; // no move
				}
				else {
					// find out who played the move
					assert(n->up());
					go::Turn tn = n->up()->get_turn();
					t << (tn == go::Black ? "#:" : "O:");
					if (m == go::MovePass ) t << "pa.";
					else t << setw(3) << left << xy_to_str(m % sz, m / sz);
				}
			}
			else t << "start";
			t << (a2 ? '>' : ' ');
			t << (s + i == c ? ']' : ' ');
		}
		else t << "         ";
		nc->draw_text(win_x, win_y + i, t.str());
	}
}
