/* ccgo: nc/face.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef NC_FACE_HH
#define NC_FACE_HH
#include <nc/nc.hh>
#include <ui/face.hh>
#include <string>
namespace nc {
	class Face :
		public ui::Face
	{
		Nc * nc;
		bool shown;
		bool active; // cursor is show when active
		int size; // board size

		// window geometry
		int win_x;
		int win_y;
		int win_w;
		int win_h;

		// cursor
		int cur_x;
		int cur_y;
		char cur_left;
		char cur_right;

		// overrides
		void new_face_size();
		void new_state(go::Loc loc);
		void new_mode();
		void new_move_from(go::Move old);
		void new_ko_from(const std::set<go::Loc> & old);
		void new_mark(go::Loc loc);
		void new_label(go::Loc loc);
	public:
		Face();
		void set_nc(Nc * n);	

		// the full board size
		unsigned get_max_w() const;
		unsigned get_max_h() const;

		// actually allocated geometry
		void set_window(int x, int y, int w, int h);

		// user input
		void set_active(bool act);
		bool get_active() const;
		void do_up();
		void do_down();
		void do_left();
		void do_right();
		void do_enter();
		void do_knock();
		void do_track();

		// setting functions
		void move_cursor(go::Loc loc);
	private:
		void draw_cursor();
		void erase_cursor();
		void draw_site(go::Loc loc);
		void draw();
		Color c_move;
		Color c_mark;
		Color c_label;
	};
}
#endif // NC_FACE_HH
