/* ccgo: nc/entry.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef NC_ENTRY_HH
#define NC_ENTRY_HH
#include <string>
#include <vector>
#include <nc/nc.hh>
namespace nc {
	class Entry
	{ // multiple line text entry
		Nc * nc;

		std::vector<std::string> buf; // text buffer

		bool shown;

		// window geometry
		int entx;
		int enty;
		int entw;
		int enth;

		// cursor position
		int entl;
		int entc;

		// buffer offset
		int curl;
		int curc;
		int top;
		int topc;

		bool need_redraw;
		bool show_guide;
	public:
		Entry();
		~Entry();

		void set_nc(Nc * n);
		void set_window(unsigned x, unsigned y, unsigned width, unsigned height);
		bool is_shown() const;
		void draw_buf();
		void set_cursor();
		std::string get_text();
		void set_text(const std::string & text);
		void set_guide(bool guide_shown); // whether to draw the guide at the left of the text
		bool get_guide() const;

		// commands
		void do_up();
		void do_down();
		void do_left();
		void do_right();
		void do_home();
		void do_end();
		void do_enter();
		void do_back();
		void do_delete();
		void do_page_up();
		void do_page_down();
		void do_insert(int c);
	};
}
#endif // NC_ENTRY_HH
