/* ccgo: nc/editor.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef NC_EDITOR_HH
#define NC_EDITOR_HH
#include <nc/face.hh>
#include <nc/map.hh>
#include <nc/entry.hh>
#include <ui/editor.hh>
namespace nc {
	class Editor :
		public ui::Editor,
		public Nc
	{
		Face face;
		Map map;
		Entry text;

		static const unsigned status_h = 6;
		// status has same width as map

		// override go::Editor
		void view_site(go::Loc loc);
		void new_node();

		// changing site properties
		enum Changer {
			ChangeNone = 0,
			ChangeMark,
			ChangeLabel
		} changer; // decide what the change_site function will change
		void change_site(go::Loc loc, go::Mark & mk, std::string & lb);

		// override Nc
		void new_window_size(unsigned w, unsigned h);
		void prompt();
		void process_key(int c);
		void draw_message(const std::string & msg);
		void clear_message();
	public:
		Editor();
		~Editor();
	private:
		// window size
		int win_w;
		int win_h;
		int status_x;
		int info_y; // y coordinate of info line

		bool status_shown; // status box
		bool map_shown;
		bool text_shown;
		bool edit_text;

		void show_map();
		void draw_status();
	};
}
#endif // NC_EDITOR_HH
