/* ccgo: go/nc.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GO_NC_HH
#define GO_NC_HH

#include <ui/editor.hh>
#include <ui/face.hh>
#include <string>

namespace Nc {
	class Editor;
	class Face :
		public ui::Face
	{
		Editor * editor;

		bool shown;
		bool active; // cursor is show when active
		int size; // board size

		// window geometry
		int win_x;
		int win_y;
		int win_w;
		int win_h;

		// cursor
		int cur_x;
		int cur_y;
	protected:
		// overrides
		void new_size();
		void new_state(go::Loc loc);
		void new_mode();
		void new_info();
	public:
		Face(Editor * ed);

		// the full board size
		int get_max_width() const;
		int get_max_height() const;

		// actually allocated geometry
		void set_window(int x, int y, int w, int h);

		// user input
		void set_active(bool act);
		void cursor_up();
		void cursor_down();
		void cursor_left();
		void cursor_right();
		void enter();

	private:
		void show_cursor();
		void hide_cursor();
		void redraw();
	};

	class Entry
	{ // multiple line text entry
	public:
		Entry();
		Entry(int x, int y, int width, int height);
		~Entry();

		void set_window(int x, int y, int width, int height);
		void draw_buf();
		void set_cursor();
		bool process_key(int c);
		std::string get_text();
		void set_text(const std::string & text);
		void set_guide(bool guide_shown); // whether to draw the guide at the left of the text
	private:
		std::vector<std::string> buf;

		bool shown;
		// window geometry
		int entx;
		int enty;
		int entw;
		int enth;

		// cursor position
		int entl;
		int entc;

		// buffer offset
		int curl;
		int curc;
		int top;
		int topc;

		bool need_redraw;
		bool show_guide;
	};

	class Editor : // There can be only one instance of this
		public ui::Editor
	{
		// override parent
		void view_site(go::Loc loc);
		void new_node();

		static int cnt; // reference count for ncursor functionality

		// private variables
		Face face;
		Entry text;
	public:
		Editor();
		~Editor();

		void win_resize(); // redistribute size of components
		bool process_key(int c);
		void loop();

	private:
		// window size
		int win_w;
		int win_h;
		int status_y;

		bool map_shown;
		bool text_shown;
		bool edit_text;

		// constants
		static const int map_width = 10; // width of the map colume
		static const int map_min_h = 6;

		void show_status_line();
		void show_map();

		void message(const std::string & msg);
	};
}
#endif // GO_NC_HH
