/* ccgo: move.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef MOVE_HH
#define MOVE_HH
#include "game.hh"
#include "modifi.hh"
namespace go {
	class Move :
		virtual public Modifi
	{
	protected:
		bool checked;
		// preset:
		Turn turn;
		// to check:
		unsigned num;
		Turn pre_turn;
		int pre_num;
		Loc pre_ko;
		Loc pre_loc;
	public:
		Move(Turn);
		Move(const Move &);
		virtual ~Move();
		virtual Modifi * dup() const;
		void set_num(unsigned);
		unsigned get_num() const;
		virtual bool check(const Game &);
		virtual void apply(Game &) const;
		virtual void undo(Game &) const;
		virtual std::string as_string() const;
	};
}
#endif // MOVE_HH
