/* ccgo: move.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "move.hh"
#include <sstream>

using namespace go;

Move::Move(Turn t)
{
	turn = t;
	num = 0;
	checked = false;
}

Move::Move(const Move & m)
{
// 	checked = false;
	checked = m.checked;
	turn = m.turn;
	num = m.num;
	pre_turn = m.pre_turn;
	pre_num = m.pre_num;
	pre_ko = m.pre_ko;
	pre_loc = m.pre_loc;
}

Move::~Move()
{
}

Modifi * Move::dup() const
{
	return new Move(* this);
}

void Move::set_num(unsigned n)
{
	if (! checked) num = n;
}

unsigned Move::get_num() const
{
	return num;
}

bool Move::check(const Game & g)
{
	if (! (turn == g.get_turn() || g.get_rule().mix_turn)) return checked = false;
	if (num == 0) num = g.get_move_num() + 1;
	else if (! (num == g.get_move_num() + 1 || g.get_rule().jump_num)) return checked = false;
	pre_turn = g.get_turn();
	pre_num = g.get_move_num();
	pre_ko = g.get_ko();
	pre_loc = g.get_last_move();
	// std::cerr << "move checked" << std::endl;
	return checked = true;
}

void Move::apply(Game & g) const
{
	if (! checked) return;
	g.set_turn(flip(turn));
	g.set_move_num(num);
	g.set_ko(Loc());
	g.set_last_move(Loc());
}

void Move::undo(Game & g) const
{
	g.set_turn(pre_turn);
	g.set_move_num(pre_num);
	g.set_ko(pre_ko);
	g.set_last_move(pre_loc);
}

std::string Move::as_string() const
{
	std::ostringstream s;
	s << num << ". " << (turn == TURN_BLACK ? "B" : "W") << ": pass";
	return s.str();
}
