/* ccgo: modifi_proper.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "modifi_proper.hh"
#include "put_move.hh"
#include "handicap.hh"
#include "setup.hh"

using namespace go;

ModifiProper::ModifiProper() :
	modifi(0)
{
}

ModifiProper::ModifiProper(const ModifiProper & m)
{
	if (m.modifi) modifi = m.modifi->dup();
	else modifi = 0;
}

ModifiProper::~ModifiProper()
{
	if (modifi) delete modifi;
}

Proper * ModifiProper::dup() const
{
	return new ModifiProper(* this);
}

// void ModifiProper::build(const Game & g, const sgf::Node & n)
// {
// 	Proper::build(g, n);
// 	const sgf::Prop * p;
// 	std::vector<Setup::Site> s;
// 	bool any_setup = false;
// 	// checking if there is any "setup" operations
// 	if ((p = n.find("AB")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(g.get_board_size());
// 		for (std::vector<Loc>::iterator i = l.begin(); i != l.end(); i ++) s.push_back(Setup::Site(* i, STATE_BLACK));
// 		any_setup = true;
// 	}
// 	if ((p = n.find("AW")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(g.get_board_size());
// 		for (std::vector<Loc>::iterator i = l.begin(); i != l.end(); i ++) s.push_back(Setup::Site(* i, STATE_WHITE));
// 		any_setup = true;
// 	}
// 	if ((p = n.find("AE")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(g.get_board_size());
// 		for (std::vector<Loc>::iterator i = l.begin(); i != l.end(); i ++) s.push_back(Setup::Site(* i, STATE_EMPTY));
// 		any_setup = true;
// 	}
// 	Turn tn;
// 	if ((p = n.find("PL")) != NULL) {
// 		if (p->as_char() == 'B') tn = TURN_BLACK;
// 		else if (p->as_char() == 'W') tn = TURN_WHITE;
// 		else { // impossible???
// 			tn = TURN_BLACK;
// 			std::cerr << "Turn error!!!" << std::endl;
// 		}
// 		any_setup = true;
// 	} else tn = g.get_turn();
// 	if (any_setup) {
// 		// in FF[4] B and W are not allowed in a setup node
// 		if ((p = n.find("B")) != NULL) {
// 			Loc l = p->as_loc(g.get_board_size());
// 			if (l != Loc()) s.push_back(Setup::Site(l, STATE_BLACK));
// 		}
// 		if ((p = n.find("W")) != NULL) {
// 			Loc l = p->as_loc(g.get_board_size());
// 			if (l != Loc()) s.push_back(Setup::Site(l, STATE_WHITE));
// 		}
// 		Setup * setup = new Setup(s, tn);
// 		setup->check(g);
// 		modifi = setup;
// 		return;
// 	}
// 	// try to build a "move" modifi
// 	Move * move = NULL;
// 	if ((p = n.find("B")) != NULL) {  // only one of B, W, and HA should happen
// 		Loc l = p->as_loc(g.get_board_size());
// 		if (l == Loc()) move = new Move(TURN_BLACK); // B pass
// 		else move = new PutMove(TURN_BLACK, l); // put B
// 	} else if ((p = n.find("W")) != NULL) {
// 		Loc l = p->as_loc(g.get_board_size());
// 		if (l == Loc()) move = new Move(TURN_WHITE); // W pass
// 		else move = new PutMove(TURN_WHITE, l); // put W
// 	} else if ((p = n.find("HA")) != NULL) { // handicap
// 		int h = p->as_int();
// 		if ((p = n.find("AB")) == NULL) move = new Handicap(h); // no handicap positions
// 		else move = new Handicap(p->ar_loc(g.get_board_size())); // w/ handicap positions
// 	}
// 	if (move != NULL) {
// 		if ((p = n.find("MN")) != NULL) move->set_num(p->as_int());
// 		if (move->check(g)) modifi = move;
// 		else delete move;
// 		move = NULL;
// 	}
// }

void ModifiProper::set_modifi(Modifi * a)
{
	if (modifi) delete modifi;
	modifi = a;
}

const Modifi * ModifiProper::get_modifi() const
{
	return modifi;
}
