/* ccgo: igs/win.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_WIN_HH
#define IGS_WIN_HH
#include "control.hh"
#include "line_box.hh"
#include "player_list.hh"
#include "game_list.hh"
#include "match.hh"
#include <gtkmm/window.h>
#include <gtkmm/entry.h>
#include <gtkmm/textview.h>
#include <gtkmm/togglebutton.h>
#include <gtkmm/button.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/box.h>
namespace igs
{
	class Win :
		virtual public Control
	{
		// Control igs;
		Gtk::Window win;
		int my_width;
		int my_height;
		void win_size_change(Gtk::Allocation &);
		void finishing();
		Gtk::TextView text_port;
		Gtk::Adjustment * vaj;
		Gtk::Label prompt;
		LineBox line_box;
		void line_input();

		Gtk::VBox * lists_box;

		Gtk::ToggleButton players_button;
		void players_toggle();
		PlayerList player_list;
		void hide_player_list();
		void show_player_list();

		void select_player(const std::string &);
		void refresh_player_list(const std::string &);
		void refresh_game_list();

		Gtk::ToggleButton games_button;
		void games_toggle();
		GameList game_list;
		void hide_game_list();

		// toggle group
		Gtk::VButtonBox * toggles_box;
		bool setting_toggle;
		Gtk::ToggleButton bell_toggle;
		Gtk::ToggleButton quiet_toggle;
		Gtk::ToggleButton shout_toggle;
		Gtk::ToggleButton automail_toggle;
		Gtk::ToggleButton open_toggle;
		Gtk::ToggleButton looking_toggle;
		Gtk::ToggleButton kibitz_toggle;
		Gtk::ToggleButton chatter_toggle;
		Gtk::ToggleButton singlegame_toggle;		

		void do_bell_toggle();
		void do_quiet_toggle();
		void do_shout_toggle();
		void do_automail_toggle();
		void do_open_toggle();
		void do_looking_toggle();
		void do_kibitz_toggle();
		void do_chatter_toggle();
		void do_singlegame_toggle();

		void miss_game(int);
		void skip_move(int);
		void unob_game(int);
		void select_game(int);
		void game_kibitz(const std::string &, TalkType, int);

		// game actions
		void send_handicap(unsigned, int);
		void send_put(const go::Loc &, unsigned, int);
		void send_pass(unsigned, int);
		void send_undo(int);
		void send_terri(const go::Loc &, int);
		void send_reset(int);
		void send_done(int);

		void send_adjourn(int);
		void send_resign(int);

		void send_tell(const std::string &, const std::string &);
		std::string match_opponent;
		void send_match(const Match &);
		void send_look(const std::string &);
		void send_load(const std::string &);
		void send_info(const std::string &);

		std::string username;

		void exit_igs();
		void conn_lost();
	public:
		Win();
		virtual ~Win();
		void cancel_conn();
		void client_ready();
		void set_prompt(PromptType);
		void set_username(const std::string &);
		void do_beep();
		void add_message(const std::string &);
		void add_tagged_message(const std::string &, const std::string &);
		void player_update(const Player &);
		void player_stats(const Player &);
		void player_odds(const Odds &);
		void player_end_update();
		void player_ask_results(const std::string &);
		void player_ask_odds(const std::string &);
		void player_ask_stored(const std::string &);
		void game_result(const std::vector<Result> &);
		void stored_game(const std::vector<Storage> &);
		void game_update(const Game &);
		void game_end_update();
		void game_move(go::Move *, int);
		void game_undo(int);
		void game_time(int, int, int, int, int);
		void game_title(int, const std::string &);
		void ob_remove(int);
		void game_finish(int, const std::string &);
		virtual void match_score(int = 0);
		virtual void match_restore(int = 0);
		virtual void match_remove(const go::Loc &, int);
		virtual void match_adjourn(int = 0);
		virtual void match_finish(const std::string &, int);
		virtual void match_message(const std::string &, int);

		virtual void match_resign(const std::string &);
		virtual void match_timeup(const std::string &);
		virtual void remove_match(const std::string &, const std::string &);

		virtual void player_update(const std::string &, const std::string &);
		virtual void player_remove(const std::string &);

		virtual void message_sys(const std::string &);
		virtual void message_tell(const std::string &);
		virtual void message_tell(const std::string &, const std::string &);
		virtual void message_yell(const std::string &);
		virtual void message_kibitz(int, const std::string &);
		virtual void message_misc(const std::string &);

		virtual void match_request(const Match &);
		virtual void match_create(int, const std::string &);
		virtual void match_decline(const std::string &);
		virtual void match_not_online(const std::string &);
		virtual void match_not_open();
		virtual void match_in_match(const std::string &);

		virtual void game_board(const Board &);
		virtual void toggle_state(ToggleType, bool);
		virtual void file_text(const std::string &);
	};
}
#endif // IGS_WIN_HH
