/* ccgo: igs/tagged_message.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "tagged_message.hh"
#include <gtkmm/scrolledwindow.h>

using namespace igs;

void TaggedMessage::on_clicked()
{
	// std::cerr << "clicked!!" << std::endl;
	ToggleButton::on_clicked();
	if (get_active()) win.show_all();
	else win.hide();
}

void TaggedMessage::window_hide()
{
	if (get_active()) set_active(false);
}

TaggedMessage::TaggedMessage(const std::string & s, const std::string & m) :
	Gtk::ToggleButton(s)
{
	Glib::RefPtr<Gtk::TextTag> t;
	(t = text.get_buffer()->create_tag("mono"))->property_family().set_value("fixed");
	text.get_buffer()->insert_with_tag(text.get_buffer()->end(), m, t);
	Gtk::ScrolledWindow * sw = Gtk::manage(new Gtk::ScrolledWindow);
	sw->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	sw->add(text);
	win.add(* sw);
	text.set_editable(false);
	win.signal_hide().connect(mem_fun(* this, & TaggedMessage::window_hide));
	win.set_title(s);
	win.set_default_size(200, 200);
}

