/* ccgo: igs/stats_box.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_STATS_BOX_HH
#define IGS_STATS_BOX_HH
#include "player.hh"
#include "result.hh"
#include <gtkmm/window.h>
#include <gtkmm/label.h>
#include <sigc++/signal.h>
#include <gtkmm/box.h>
#include <gtkmm/textview.h>
#include <gtkmm/entry.h>
namespace igs
{
	class StatsBox :
		public Gtk::VBox
	{
		Player player;
		std::string name;

		Gtk::Label rank;
		Gtk::Label rated_games;
		Gtk::HBox state_box;
		Gtk::Label state;
		Gtk::Button game;
		Gtk::Label reg_date;
		Gtk::Label idle_label;
		Gtk::Label idle_time;
		Gtk::Label address;

		Gtk::TextView info_box;

		void hit_game();

		Gtk::Button change;
		bool info_edit;
		void change_clicked();
	public:
		StatsBox(const std::string &);
		~StatsBox();
		void update(const Player &);
		void attach_result(const Result &);
		sigc::signal<void, int> select_game;
		void set_info_edit(bool = true);
		sigc::signal<void, const std::string &> info_change;
	};
}
#endif // IGS_STATS_BOX_HH
