/* ccgo: igs/stats_box.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "../config.hh"
#include "../gettext.h"
#include "stats_box.hh"
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/stock.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/scrolledwindow.h>
#include <iostream>
#include <sstream>

#define _(String) Glib::locale_to_utf8(gettext(String))

using namespace igs;

void StatsBox::hit_game()
{
	if (player.playing > 0) {
		select_game(player.playing);
		return;
	}		
	if (player.observing > 0) {
		select_game(player.observing);
		return;
	}
}

void StatsBox::change_clicked()
{
	std::string s = info_box.get_buffer()->get_text();
	for (unsigned i = 0; i < s.length(); i ++) if (s[i] == '\n') s[i] = ' ';
	info_change(s);
}

StatsBox::StatsBox(const std::string & n) :
	name(n),
	change(_("change"))
{
	Gtk::HBox * hb;
	Gtk::Label * lb;

	hb = Gtk::manage(new Gtk::HBox);
	pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Player") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(name));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	lb->set_selectable(true);

	hb = Gtk::manage(new Gtk::HBox);
	pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Rating") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	hb->pack_start(rank, Gtk::PACK_SHRINK);

	hb = Gtk::manage(new Gtk::HBox);
	pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Rated Games") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	hb->pack_start(rated_games, Gtk::PACK_SHRINK);

	hb = Gtk::manage(new Gtk::HBox);
	pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Registered") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	hb->pack_start(reg_date, Gtk::PACK_SHRINK);

	hb = Gtk::manage(new Gtk::HBox);
	pack_start(* hb, Gtk::PACK_SHRINK);
	idle_label.set_text(_("Idle Time") + ": ");
	hb->pack_start(idle_label, Gtk::PACK_SHRINK);
	hb->pack_start(idle_time, Gtk::PACK_SHRINK);

	pack_start(state_box, Gtk::PACK_SHRINK);
	state_box.pack_start(state, Gtk::PACK_SHRINK);
	state_box.pack_start(game, Gtk::PACK_SHRINK);
	game.signal_clicked().connect(mem_fun(* this, & StatsBox::hit_game));

	hb = Gtk::manage(new Gtk::HBox);
	pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Address") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	hb->pack_start(address, Gtk::PACK_SHRINK);
	address.set_selectable(true);

	Gtk::ScrolledWindow * sw = Gtk::manage(new Gtk::ScrolledWindow);
	sw->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	sw->add(info_box);
	pack_end(* sw, Gtk::PACK_SHRINK);
	info_box.set_editable(false);
	info_box.set_cursor_visible(false);
	info_box.set_wrap_mode(Gtk::WRAP_WORD);

	hb = Gtk::manage(new Gtk::HBox);
	pack_end(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Info") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	hb->pack_end(change, Gtk::PACK_SHRINK);
	change.signal_clicked().connect(mem_fun(* this, & StatsBox::change_clicked));

	show_all();
	state_box.hide();
	change.hide();
	info_edit = false;
}

StatsBox::~StatsBox()
{
	// std::cerr << "deleting StatsBox" << std::endl;
}

void StatsBox::update(const Player & p)
{

	player.update(p);

	rank.set_text(player.get_rank().long_text());

	std::ostringstream o;
	o << player.get_rated_games();
	rated_games.set_text(o.str());
	reg_date.set_text(player.get_reg_date().to_str());
	if (p.get_last()) {
		idle_label.set_text(_("Last Login") + ": ");
		idle_time.set_text(player.get_last().to_str());
	} else {
		idle_label.set_text(_("Idle Time") + ": ");
		idle_time.set_text(player.get_idle().long_text());
	}
	address.set_text(player.get_address());
	info_box.get_buffer()->set_text(player.get_info());

	if (p.playing <= 0 && p.observing <= 0) state_box.hide();
	else {
		o.str("");
		state_box.show();
		if (p.playing > 0) {
			state.set_text(_("Playing in game") + ": ");
			o << p.playing;
		} else {
			state.set_text(_("Observing game") + ": ");
			o << p.observing;
		}
		game.set_label(o.str());
	}
}

void StatsBox::attach_result(const Result & r)
{
	// std::cerr << "attaching result  W=" << r.white << " B=" << r.black << std::endl;
}

void StatsBox::set_info_edit(bool b)
{
	info_edit = b;
	if (b) change.show();
	else change.hide();
	info_box.set_editable(b);
	info_box.set_cursor_visible(b);
}
