/* ccgo: igs/static.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "../config.hh"
#include "../gettext.h"
#include "static.hh"
#include "../settings.hh"
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/stock.h>

#include <cstdio>
#define _(String) Glib::locale_to_utf8(gettext(String))

using namespace igs;

void Static::on_hide()
{
	delete this;
}

void Static::on_size_allocate(Gtk::Allocation & a)
{
	Gtk::Widget::on_size_allocate(a);
	if (a.get_width() != my_width || a.get_height() != my_height) {
		my_width = a.get_width();
		my_height = a.get_height();
		go::settings.set_int("igs-static-width", my_width);
		go::settings.set_int("igs-static-height", my_height);
	}
}

Static::Static(unsigned z) :
	head_line(_("Static game board"))
{
	std::string ip = go::settings.get_image_path();
	if (Glib::file_test(ip + "/observing_icon.png", Glib::FILE_TEST_EXISTS)) {
		set_icon(Gdk::Pixbuf::create_from_file(ip + "/observing_icon.png"));
	}

	board.set_board_size(z); // not needed

	Gtk::VBox * vb = Gtk::manage(new Gtk::VBox);
	add(* vb);

	vb->pack_start(head_line, Gtk::PACK_SHRINK);

	Gtk::HBox * hb = Gtk::manage(new Gtk::HBox);
	vb->pack_start(* hb);

	vb->pack_start(date, Gtk::PACK_SHRINK);
	vb->pack_start(record, Gtk::PACK_SHRINK);

	hb->pack_start(board);

	vb = Gtk::manage(new Gtk::VBox);
	hb->pack_end(* vb, Gtk::PACK_SHRINK);

	Gtk::Button * bt = Gtk::manage(new Gtk::Button(Gtk::Stock::CLOSE));
	vb->pack_end(* bt, Gtk::PACK_SHRINK);
	bt->signal_clicked().connect(mem_fun(* this, & Window::hide));

	my_width = go::settings.get_int("igs-static-width");
	if (my_width <= 0) my_width = 320;
	my_height = go::settings.get_int("igs-static-height");
	if (my_height <= 0) my_height = 360;
	resize(my_width, my_height);

	// set_default_size(400, 350);

	show_all();
}

void Static::set_board(const Board & b)
{
	char buf[100];
	snprintf(buf, 100, _("%s vs %s").c_str(), b.white.c_str(), b.black.c_str());
	Glib::ustring h(buf);
	set_title(h);
	h = _("Static board") + ": " + h;
	head_line.set_text(h);
	board.set_board_size(b.board_size);
	if (b.is_score) { // Hum... shouldn't come here!
		if (b.score.length()) record.set_text(_("Score") + ": " + b.score);
	} else {
		if (b.date) date.set_text(_("Date") + ": " + b.date.to_str());
		if (b.record) record.set_text(_("Record") + ": " + b.record.to_str());
	}
	for (int x = 0; x < b.board_size; x ++) {
		for (int y = 0; y < b.board_size; y ++) {
			switch (b.state[go::Loc(x, y).expand(b.board_size)]) {
			case 0:
				board.set_site(go::Loc(x, y), go::STATE_BLACK);
				break;
			case 1:
				board.set_site(go::Loc(x, y), go::STATE_WHITE);
				break;
			default:
				board.set_site(go::Loc(x, y), go::STATE_EMPTY);
			}
		}
	}
}
