/* ccgo: igs/sock.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_SOCK_HH
#define IGS_SOCK_HH
#include "connect.hh"
#include <glibmm.h>
#include <string>
namespace igs
{
	class Sock :
		virtual public Connect
	{
		int sock_id;

		sigc::connection grab_line_connection;
		bool grab_action;
		bool grab_line(Glib::IOCondition);
		bool read_buffer();
		bool reading_buffer;

		sigc::connection time_up_connection;
		bool time_up();
		int idle_time;

	protected:
		std::string line_buffer;
	public:
		Sock(const std::string &, unsigned short);
		virtual ~Sock();
		void send_line(const std::string &);

		bool open_sock(const std::string &, unsigned short);
		void close_sock();
	};
}
#endif // IGS_SOCK_HH
