/* ccgo: igs/show.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_SHOW_HH
#define IGS_SHOW_HH
#include "../part.hh"
#include "../player.hh"
#include "board.hh"
#include "line_box.hh"
#include <gtkmm/window.h>
#include <sigc++/signal.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/optionmenu.h>
#include <gtkmm/dialog.h>
namespace igs
{
	enum TalkType {
		TALK_CHATTER,
		TALK_KIBITZ,
		TALK_SAY,
		TALK_TELL,
		TALK_RAW
	};

	class TalkSelect :
		public Gtk::OptionMenu
	{
		Gtk::MenuItem talk_chatter;
		Gtk::MenuItem talk_kibitz;
		Gtk::MenuItem talk_say;
		Gtk::MenuItem talk_tell;
		Gtk::MenuItem talk_raw;
	public:
		TalkSelect();
		TalkType get_type();
		void disable_talk(TalkType);
	};

	class ResignDialog :
		public Gtk::Dialog
	{
		void on_response(int);
	public:
		ResignDialog();
		sigc::signal0<void> confirmed;
	};

	class Show :
		public Gtk::Window,
		public go::Player
	{
		go::Part part;
		Gtk::Label header_text;
		Gtk::Button adjourn_button;
		Gtk::Button resign_button;
		Gtk::Button close_button;
		Gtk::TextView message_box;

		TalkSelect talk_select;

		LineBox line_box;
		void line_input();

		Gtk::Adjustment * vaj;

		bool no_close;

		void on_hide();
		int my_width;
		int my_height;
		void on_size_allocate(Gtk::Allocation &);

		int my_vpaned_position;
		Gtk::VPaned vpaned;
		bool handle_move(Gtk::ScrollType);

		ResignDialog resign_dialog;
		void resign_hit();
	public:
		Show(unsigned);
		~Show();

		sigc::signal<void, Show *> show_close;
		void set_play(bool, bool);
		void set_komi(double);
		int move_num();
		bool add_move(go::Move *);
		bool undo_move();
		void hang_up(const std::string & = "");
		void start_time(int, int, int);
		void sync_time(int, int, int, int);
		void set_header(const std::string &);
		void add_message(const std::string &);

		void show_score();
		void show_restore();
		void show_terri(const go::Loc & l);
// 		void show_adjourn();
		void show_score_board(const Board &);

		sigc::signal<void, const std::string &, TalkType> input_line;

		sigc::signal<void, unsigned> input_handicap;
		sigc::signal<void, const go::Loc &, unsigned> input_put;
		sigc::signal<void, unsigned> input_pass;
		sigc::signal<void> input_undo;
		sigc::signal<void, const go::Loc &> input_terri;
		sigc::signal<void> input_reset;
		sigc::signal<void> input_done;

		sigc::signal<void> input_adjourn;
		sigc::signal<void> input_resign;
	};
}
#endif // IGS_SHOW_HH
