/* ccgo: igs/result.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "../config.hh"
#include "../gettext.h"
#include "result.hh"
#include "player.hh"
#include <sstream>
#include <iostream>

#include <cstdio>
#define _(String) Glib::locale_to_utf8(gettext(String))

using namespace igs;
using namespace std;


Result::Result()
{
	ok = false;
}

bool Result::build(const string & s)
{
	raw = s;
	if (s.length() < 61) return ok = false;
	istringstream tp; // temporary string stream
	if (s[18] == 'B') {
		winer = go::TURN_BLACK;
		tp.str(s.substr(0, 10));
		tp.clear();
		tp >> black;
		b_rank = Player::Rank(s.substr(12, 4));
		tp.str(s.substr(23, 10));
		tp.clear();
		tp >> white;
		w_rank = Player::Rank(s.substr(35, 4));
	} else {
		winer = go::TURN_WHITE;
		tp.str(s.substr(0, 10));
		tp.clear();
		tp >> white;
		w_rank = Player::Rank(s.substr(12, 4));
		tp.str(s.substr(23, 10));
		tp.clear();
		tp >> black;
		b_rank = Player::Rank(s.substr(35, 4));
	}

	istringstream t(s.substr(46));
	string ss;
	char c;
	t >> handicap;
	t >> c;
	if (c != 'K') return ok = false;
	t >> komi;
	t >> ss;
	tp.str(ss);
	tp.clear();
	tp >> board_size;
	t >> ss;

	if ((ss[0] != 'W' && ss[0] != 'B') || ss[1] != '+') return ok = false;
	if (ss.substr(2) == "Time") win_type = WIN_TIME;
	else if (ss.substr(2) == "Resign") win_type = WIN_RESIGN;
	else {
		win_type = WIN_COUNT;
		tp.str(ss.substr(2));
		tp.clear();
		tp >> win;
	}
	t >> ss;
	tp.str(ss.substr(0, 2));
	tp.clear();
	tp >> date;
	tp.str(ss.substr(3, 2));
	tp.clear();
	tp >> hour;
	tp.str(ss.substr(5, 2));
	tp.clear();
	tp >> minute;
	t >> c;
	rated = c == 'R';
	return ok = true;

}

Result::operator bool () const
{
	return ok;
}

const Glib::ustring Result::short_text() const
{
	Glib::ustring u;
	if (winer == go::TURN_BLACK) {
		u = black + "[" + b_rank.get_text() + "]" + _("(B)") + "-" + white + "[" + w_rank.get_text() + "]";
	} else {
		u = white + "[" + w_rank.get_text() + "]" + _("(W)") + "-" + black + "[" + b_rank.get_text() + "]";
	}

	char buf[100];
	switch (win_type) {
	case WIN_COUNT:
		snprintf(buf, 100, _("+%g").c_str(), win);
		u.append(buf);
		break;
	case WIN_RESIGN:
		u += _("+resign");
		break;
	case WIN_TIME:
		u += _("+time");
		break;
	}
	if (rated) u += "*";
	return u;
}

const Glib::ustring Result::short_text(const string & n) const
{
	Glib::ustring u;

	Glib::ustring w;
	Glib::ustring b;
	if (white == n) {
		w = n + _("(W)");
		b = black + "[" + b_rank.get_text() + "]";
	} else if (black == n) {
		b = n + _("(B)");
		w = white + "[" + w_rank.get_text() + "]";
	} else {
		b = black + "[" + b_rank.get_text() + "]" + _("(B)");
		w = white + "[" + w_rank.get_text() + "]" + _("(W)");
	}
	if (winer == go::TURN_BLACK) {
		u = b + "-" + w;
	} else {
		u = w + "-" + b;
	}

	char buf[100];
	switch (win_type) {
	case WIN_COUNT:
		snprintf(buf, 100, _("+%g").c_str(), win);
		u.append(buf);
		break;
	case WIN_RESIGN:
		u += _("+resign");
		break;
	case WIN_TIME:
		u += _("+time");
		break;
	}
	if (rated) u += "*";
	return u;
}
