/* ccgo: igs/player_list.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_PLAYER_LIST_HH
#define IGS_PLAYER_LIST_HH
#include "player.hh"
#include "stats_box.hh"
#include "result.hh"
#include "storage.hh"
#include "odds.hh"
#include "line_box.hh"
#include "match_win.hh"
#include <gtkmm/window.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/label.h>
#include <gtkmm/notebook.h>
#include <gtkmm/textview.h>
#include <gtkmm/entry.h>
#include <gtkmm/optionmenu.h>
#include <vector>
namespace igs
{

	class PlayerList :
		public Gtk::Window
	{
		std::string name;
		Gtk::Label n_players;
		void update_n_players();
		Gtk::Entry refresh_filter;

		Gtk::Entry stats_name;

		Gtk::TreeView view;
		class ModelCol :
			public Gtk::TreeModel::ColumnRecord
		{
		public:
			ModelCol();
			Gtk::TreeModelColumn<std::string> name;
			Gtk::TreeModelColumn<void *> rank;
			Gtk::TreeModelColumn<void *> state;
			Gtk::TreeModelColumn<void *> idle;
		};
		ModelCol m_col;
		Glib::RefPtr<Gtk::ListStore> store;
		bool sort_toggle;
		Gtk::TreeView::Column * sort_col;
		Gtk::SortType sort_type;
		void sort_by(Gtk::TreeView::Column *);
		void select_player(const Gtk::TreeModel::Path &, Gtk::TreeViewColumn *);
		struct Record
		{
			Player player;
			StatsBox * stats_box;
			MatchBox * match_box;
			Gtk::TreeModel::Children::iterator iter;
		};
		std::vector<Record> list;
		CustomText::CellRenderer rank_render;
		CustomText::CellRenderer state_render;
		CustomText::CellRenderer idle_render;

		void refresh_request();
		time_t refresh_time;

		Gtk::Notebook stats_book;
		void page_change(GtkNotebookPage *, int);
		Gtk::TextView text_area;
		Gtk::Adjustment * vaj;
		Gtk::Label talk_type;
		LineBox talk_box;
		void refresh_stats();
		void results_stats();
		void odds_stats();
		void stored_stats();
		void match_stats();
		void close_stats();

		void close_match(MatchBox *);

		void add_message(const Glib::ustring &);
		void clear_text();
		void enter_name();
		StatsBox * new_stats_box(const std::string &);
		void ready_stats(const std::string &);
		void enter_talk();

		void open_stored(std::string);
		void execute_stored(std::string);

		int my_width;
		int my_height;
		void on_size_allocate(Gtk::Allocation &);
	public:
		PlayerList();
		~PlayerList();
		void set_name(const std::string &);
		void update(const Player &);
		void stats(const Player &);
		void odds(const Odds &);
		void end_update();
		void add_result(const std::vector<Result> &);
		void add_stored(const std::vector<Storage> &);
		void msg_tell(const std::string &, const std::string &);
		void match_request(const Match &);
		void match_create(const std::string &);
		void match_decline(const std::string &);
		void match_not_online(const std::string &);
		void match_not_open(const std::string &);
		void match_in_match(const std::string &);

		sigc::signal<void, const std::string &> player_selected;
		sigc::signal<void, const std::string &> refresh_list;
		sigc::signal<void, const std::string &> ask_results;
		sigc::signal<void, const std::string &> ask_odds;
		sigc::signal<void, const std::string &> ask_stored;
		sigc::signal<void, int> select_game;
		sigc::signal<void, const std::string &, const std::string &> talk_to_player;
		sigc::signal<void, const Match &> enter_match;
		sigc::signal<void, const std::string &> lookup_stored;
		sigc::signal<void, const std::string &> load_stored;

		sigc::signal<void, const std::string &> change_info;

		MatchWin match_win;
	};
}
#endif // IGS_PLAYER_LIST_HH
