/* ccgo: igs/player.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_PLAYER_HH
#define IGS_PLAYER_HH
#include "custom_text.hh"
#include "datetime.hh"
#include <string>
#include <sigc++/object.h>
#include <ctime>

namespace igs
{
	class Player
	{
	public:
		class Rank :
			public CustomText
		{
			double strength;
			bool certified;
			std::string rank;
			void make_str();
		public:
			Rank();
			Rank(const std::string &);
			virtual ~Rank();
			bool build(const std::string &);
			const std::string & get_text() const;
			bool operator < (const CustomText &) const;
			operator bool() const;
			const Glib::ustring long_text() const;
		};

		class State :
			public CustomText
		{
			enum NumState {
				STATE_UNKNOWN = 0,
				STATE_CLOSE,
				STATE_OPEN,
				STATE_LOOK
			};
			NumState state;
			std::string str;
		public:
			State();
			State(const std::string &);
			virtual ~State();
			const std::string & get_text() const;
			bool operator < (const CustomText &) const;
			operator bool() const;
			const std::string long_text() const;
		};

		class Idle :
			public CustomText
		{
			std::string str;
			int time;
		public:
			Idle();
			Idle(const std::string &);
			virtual ~Idle();
			void offline();
			const std::string & get_text() const;
			bool operator < (const CustomText &) const;
			operator bool() const;
			const Glib::ustring long_text() const;
			bool is_online() const;
		};


	private:
		time_t stamp;
	public:
		std::string name;
		Rank rank;
		State state;
		int game;
		std::string language;
		int rated_games;
		Rank self_rank;
		int wins;
		int losses;
		int observing;
		int playing;
		Datetime last;
		Idle idle;
		std::string address;
		Datetime reg_date;
		Glib::ustring info;
		int def_time;
		int def_size;
		int def_byo_time;
		int def_byo_stones;

		Player();
		void update(const Player &);

		const std::string & get_name() const {return name;}
		void set_name(const std::string & n) {name = n;}
		const Rank & get_rank() const {return rank;}
		void set_rank(const Rank & r) {rank = r;}
		const State & get_state() const {return state;}
		void set_state(const State & s) {state = s;}
		int get_game() const {return game;}
		void set_game(int g) {game = g;}
		const std::string & get_language() const {return language;}
		void set_language(const std::string & l) {language = l;}
		int get_rated_games() const {return rated_games;}
		void set_rated_games(int r) {rated_games = r;}
		const Rank & get_self_rank() const{return self_rank;}
		void set_self_rank(const Rank & r) {self_rank = r;}
		int get_wins() const {return wins;}
		void set_wins(int w) {wins = w;}
		int get_losses() const {return losses;}
		void set_losses(int l) {losses = l;}
		const Datetime get_last() const {return last;}
		void set_last(const std::string & l) {last.set(l);}
		const Idle & get_idle() const {return idle;}
		void set_idle(const Idle & i) {idle = i;}
		const std::string & get_address() const {return address;}
		void set_address(const std::string & a) {address = a;}
		const Datetime & get_reg_date() const {return reg_date;}
		void set_reg_date(const std::string & r) {reg_date.set(r);}
		const Glib::ustring & get_info() const {return info;}
		void set_info(const Glib::ustring & i) {info = i;}
		int get_def_time() const {return def_time;}
		void set_def_time(int t) {def_time = t;}
		int get_def_size() const {return def_size;}
		void set_def_size(int s) {def_size = s;}
		int get_def_byo_time() const {return def_byo_time;}
		void set_def_byo_time(int t) {def_byo_time = t;}
		int get_def_byo_stones() const {return def_byo_stones;}
		void set_def_byo_stones(int s) {def_byo_stones = s;}

		time_t get_stamp() const {return stamp;}
	};
}
#endif // IGS_PLAYER_HH
