/* ccgo: igs/parser/stored.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "stored.hh"
#include "../encode.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern Stored parser_stored;
Stored Stored::parser_stored(& Stored::parser_stored);

Parser * Stored::id(Control * c) const
{
	if (c->get_num_cmd() != 18) return 0;
	Stored * p = new Stored(c);
	p->process();
	return p;
}

Stored::Stored(Parser * p) :
	Parser(p)
{
}

Stored::Stored(Control * c) :
	Parser(c)
{
	complete = false;
}

Stored::~Stored()
{
	if (complete) control->stored_game(list);
}

bool Stored::process()
{
	if (complete) return false;
	if (control->get_num_cmd() != 18) return false;
	std::istringstream s(control->get_cmd_dat());
	std::string d;
	s >> d;
	if (d == "Found") {
		complete = true;
		return true;
	}
	do {
		if (! s.fail()) {
			//control->stored_game(d);
			Storage t;
			if (t.build(d)) list.push_back(t);
		}
		else break;
		s >> d;
	} while (true);
	return true;
}
