/* ccgo: igs/parser/stats.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "stats.hh"
#include "../encode.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern Stats parser_stats;
Stats Stats::parser_stats(& Stats::parser_stats);

Parser * Stats::id(Control * c) const
{
	if (c->get_num_cmd() != 9) return 0;
	if (c->get_cmd_dat().substr(0, 13) != "Player:      ") return 0;
	Stats * p = new Stats(c);
	p->p.set_name(c->get_cmd_dat().substr(13));
	return p;
}

Stats::Stats(Parser * p) :
	Parser(p)
{
}

Stats::Stats(Control * c) :
	Parser(c)
{
	complete = false;
	my_stats = false;
	p.playing = 0;
	p.observing = 0;
	p.idle.offline();
}

Stats::~Stats()
{
	if (complete) control->player_stats(p);
}

bool Stats::process()
{
	if (control->get_num_cmd() != 9) {
		return false;
	}
	std::istringstream s(control->get_cmd_dat());
	std::string d;
	s >> d;
// 	std::cerr << ">" << d << "<" << std::endl;
	int i;
	if (d == "Game:") {
		s >> d;
		s >> d;
		p.set_game(d[1] - '0');
	} else if (d == "Language:") {
		s >> d;
		p.set_language(d);
	} else if (d == "Rating:") {
		s >> d;
		p.set_rank(Player::Rank(d));
	} else if (d == "Rated") {
		s >> d;
		s >> i;
		p.set_rated_games(i);
	} else if (d == "Rank:") {
		s >> d;
		p.set_self_rank(Player::Rank(d));
	} else if (d == "Wins:") {
		s >> i;
		p.set_wins(i);
	} else if (d == "Losses:") {
		s >> i;
		p.set_losses(i);
	} else if (d == "Idle") {
		s >> d >> d >> d >> d;
		p.set_idle(d);
	} else if (d == "Observing") {
		s >> d >> p.observing;
	} else if (d == "Playing") {
		s >> d >> d >> p.playing;
	} else if (d == "Last") {
		s >> d;
		if (d == "Access(local):") {
			d = control->get_cmd_dat().substr(32);
			p.set_last(d);
		}
	} else if (d == "Address:") {
		d = "";
		s >> d;
		p.set_address(d);
	} else if (d == "IP") {
		d = control->get_cmd_dat().substr(10);
		p.set_address(std::string("(IP)") + d);
	} else if (d == "Reg") {
		d = control->get_cmd_dat().substr(10);
		p.set_reg_date(d);
	} else if (d == "Info:") {
		d = control->get_cmd_dat().substr(7);
		Glib::ustring u = d;
		if (! u.validate()) {
			u = auto_convert(d);
		}
// 		if (u.length() > 256) {
// 			u = u.substr(0, 256) + "[Truncated]";
// 		}
		p.set_info(u);
	} else if (d == "Defaults") {
		s >> d >> d >> d >> i;
		p.set_def_time(i);
		s.get();
		s >> d >> i;
		p.set_def_size(i);
		s.get();
		s >> d >> d >> i;
		p.set_def_byo_time(i);
		s.get();
		s >> d >> d >> i;
		p.set_def_byo_stones(i);
		complete = true;
	} else if (d == "Verbose") { // this is my stats
		my_stats = true;
		complete = false;
	} else if (my_stats) {
		def_verbose = d == "On";
		s >> d;
		def_bell = d == "On";
		s >> d;
		def_quiet = d == "On";
		s >> d;
		def_shout = d == "On";
		s >> d;
		def_automail = d == "On";
		s >> d;
		def_open = d == "On";
		s >> d;
		def_looking = d == "On";
		s >> d;
		def_client = d == "On";
		s >> d;
		def_kibitz = d == "On";
		s >> d;
		def_chatter = d == "On";

		control->toggle_state(TOGGLE_VERBOSE, def_verbose);
		control->toggle_state(TOGGLE_BELL, def_bell);
		control->toggle_state(TOGGLE_QUIET, def_quiet);
		control->toggle_state(TOGGLE_SHOUT, def_shout);
		control->toggle_state(TOGGLE_AUTOMAIL, def_automail);
		control->toggle_state(TOGGLE_OPEN, def_open);
		control->toggle_state(TOGGLE_LOOKING, def_looking);
		control->toggle_state(TOGGLE_CLIENT, def_client);
		control->toggle_state(TOGGLE_KIBITZ, def_kibitz);
		control->toggle_state(TOGGLE_CHATTER, def_chatter);

		char ss[3] = "  ";
		if (! def_open) ss[1] = 'X';
		else if (def_looking) ss[1] = '!';
		if (def_quiet) ss[0] = 'Q';
		else if (! def_shout) ss[0] = 'S';
		p.set_state(Player::State(ss));

		complete = true;
	} else { // some new field?
		return true;
	}
	return true;
}
