/* ccgo: igs/parser/say.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "say.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern Say parser_say;
Say Say::parser_say(& Say::parser_say);

Parser * Say::id(Control * c) const
{
	if (c->get_num_cmd() != 51) return 0;
	Say * k = new Say(c);
	if (k->parse_head()) return k;
	delete k;
	return 0;
}

bool Say::parse_head()
{
	if (control->get_cmd_dat().substr(0, 12) != "Say in game ") return false;
	game = -1;
	std::istringstream(control->get_cmd_dat().substr(12)) >> game;
	if (game < 0) return false;
	return true;
}

Say::Say(Parser * p) :
	Parser(p)
{
}

Say::Say(Control * c) :
	Parser(c)
{
	complete = false;
}

Say::~Say()
{
}

bool Say::process()
{
	if (complete) return false;
	if (control->get_line() == "") return true; // skip empty lines
	if (control->get_num_cmd() != 19) return false;
	std::string s = control->get_cmd_dat();
	if (s[0] != '*') return false;
	std::string::size_type i = 1;
	std::string w;
	while (i < s.length() && s[i] != '*') {
		w += s[i];
		i ++;
	} 
	if (i >= s.length() || s[i] != ':') return false;
	w += ": ";
	w += s.substr(i + 1);
	control->message_kibitz(game, w);
	complete = true;
	return true;
}
