/* ccgo: igs/parser/results.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "results.hh"
#include "../result.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern Results parser_results;
Results Results::parser_results(& Results::parser_results);

Parser * Results::id(Control * c) const
{
	if (c->get_num_cmd() != 25 || c->get_cmd_dat() != "File") return 0;
	return new Results(c);
}

Results::Results(Parser * p) :
	Parser(p)
{
}

Results::Results(Control * c) :
	Parser(c)
{
	finish = false;
}

Results::~Results()
{
}

bool Results::process()
{
	if (finish) return false;
	if (control->get_line() == "25 File") {
		control->game_result(list);
		finish = true;
		return true;
	}
	Result r;
	if (r.build(control->get_line())) list.push_back(r);
	// if (r) control->game_result(r);
	return true;
}
