/* ccgo: igs/parser/prompt.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "prompt.hh"
#include <sstream>
#include <iostream>

using namespace igs;
using namespace parser;

// extern Prompt parser_prompt;
Prompt Prompt::parser_prompt(& Prompt::parser_prompt);

igs::Parser * parser::Prompt::id(Control * c) const
{
	if (c->get_num_cmd() == 1) {
		std::istringstream s(c->get_cmd_dat());
		int code;
		s >> code;
		switch (code) {
		case 5:
			c->set_prompt(PROMPT_NORMAL);
			break;
		case 6:
			c->set_prompt(PROMPT_MATCH);
			break;
		case 7:
			c->set_prompt(PROMPT_SCORE);
			break;
		case 8:
			c->set_prompt(PROMPT_OBSERVE);
			break;
		default:
			std::cerr << "unknown prompt code " << code << std::endl;
		}
		return new Prompt(c);
	} else if (c->get_num_cmd() == 2) {
		c->do_beep();
		return new Prompt(c);
	}
	return 0;
}

parser::Prompt::Prompt(Parser * p) :
	Parser(p)
{
}

Prompt::Prompt(Control * c) :
	Parser(c)
{
}

Prompt::~Prompt()
{
}

bool Prompt::process()
{
	return false;
}
