/* ccgo: igs/parser/prob.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "prob.hh"
#include "../encode.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern Prob parser_prob;
Prob Prob::parser_prob(& Prob::parser_prob);

Parser * Prob::id(Control * c) const
{
	if (c->get_num_cmd() != 9) return 0;
	if (c->get_cmd_dat().substr(0, 12) != "The handicap") return 0;
	Prob * p = new Prob(c);
	return p;
}

Prob::Prob(Parser * p) :
	Parser(p)
{
}

Prob::Prob(Control * c) :
	Parser(c)
{
	complete = false;
}

Prob::~Prob()
{
}

bool Prob::process()
{
	if (complete) return false;
	if (control->get_num_cmd() != 9) return false;
	if (control->get_cmd_dat().substr(0, 6) == "A komi") return true;
	else if (control->get_cmd_dat().substr(0, 6) == "Is the") return true;
	else if (control->get_cmd_dat().substr(0, 6) == "Your r") {
		std::istringstream s(control->get_cmd_dat());
		std::string d;
		s >> d >> d >> odds.my_rating >> d >> d >> odds.his_rating >> d >> d >> odds.handicap;
	} else if (control->get_cmd_dat().substr(11, 5) == "WHITE") {
		std::istringstream s(control->get_cmd_dat());
		std::string d;
		s >> d >> d >> d >> d >> odds.win_as_white;
	} else if (control->get_cmd_dat().substr(11, 5) == "BLACK") {
		std::istringstream s(control->get_cmd_dat());
		std::string d;
		s >> d >> d >> d >> d >> odds.win_as_black;
		complete = true;
		control->player_odds(odds);
	}
	return true;
}
