/* ccgo: igs/parser/player_info.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "player_info.hh"
#include "../player.hh"
#include <sstream>
#include <iostream>

using namespace igs;
using namespace parser;

// extern PlayerInfo parser_player_info;
PlayerInfo PlayerInfo::parser_player_info(& PlayerInfo::parser_player_info);

Parser * PlayerInfo::id(Control * c) const
{
	if (c->get_num_cmd() != 27) return 0;
	// throw away first line
	return new PlayerInfo(c);
}

PlayerInfo::PlayerInfo(Parser * p) :
	Parser(p)
{
}

PlayerInfo::PlayerInfo(Control * c) :
	Parser(c)
{
}

PlayerInfo::~PlayerInfo()
{
	// finished player info
}

bool PlayerInfo::process()
{
	int cmd = control->get_num_cmd();
	if (cmd != 27) return false;
	std::string dat = control->get_cmd_dat();
	if (dat.length() == 71 && dat[35] == '|') for (int i = 1; i < 40; i += 37) {
		std::string s = dat.substr(i, 33);
		if (s[11] == ' ') { // logon entry
			// std::cerr << "Logon: " << s << std::endl;
			continue;
		}
		Player p;
		std::string n;
		std::istringstream x(s.substr(11, 10));
		x >> n;
		p.set_name(n);
		p.set_rank(Player::Rank(s.substr(29, 4)));
		p.set_state(Player::State(s.substr(0, 2)));
		p.set_idle(Player::Idle(s.substr(21, 4)));
		p.observing = 0;
		std::istringstream(s.substr(2, 3)) >> p.observing;
		p.playing = 0;
		std::istringstream(s.substr(7, 3)) >> p.playing;
		// std::cerr << "s=[" << s << "]\n";
		control->player_update(p);
	} else if (dat.length() > 20 && dat[16] == '*') {
		// bottom line " ... Players ... Total Games ... "
		// std::cerr << dat << std::endl;
		control->player_end_update();
	} else {
		std::cerr << "errors" << std::endl;
	}
	return true;
}
