/* ccgo: igs/parser/parser.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_PARSER_HH
#define IGS_PARSER_HH
#include <vector>
#include <string>
namespace igs
{
	class Control;

	class Parser
	{
		static Parser parser;
	protected:
		Control * control;
		static std::vector<Parser *> * parser_list;
		static Parser * list_holder;
		std::vector<Parser *> & get_parser_list();
		virtual Parser * id(Control *) const;
	public:
		static void init_parser_list();
		static Parser * search_id(Control *);
		Parser(Parser *);
		Parser(Control *);
		virtual ~Parser();
		virtual bool process();
	};



}
#include "../control.hh"
#endif // IGS_PARSER_HH
