/* ccgo: igs/parser/parser.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "parser.hh"
#include <iostream>
#include "../../settings.hh"
#include "automatch.hh"
#include "board.hh"
#include "decline.hh"
#include "file.hh"
#include "game_info.hh"
#include "kibitz.hh"
#include "match.hh"
#include "match_start.hh"
#include "misc.hh"
#include "move.hh"
#include "player_info.hh"
#include "prob.hh"
#include "prompt.hh"
#include "results.hh"
#include "say.hh"
#include "stats.hh"
#include "stored.hh"

using namespace igs;

std::vector<Parser *> * Parser::parser_list = 0;

Parser * Parser::list_holder = 0;
// extern Parser parser_parser;
Parser Parser::parser(& Parser::parser);

std::vector<Parser *> & Parser::get_parser_list()
{
	if (! parser_list) {
		parser_list = new std::vector <Parser *>;
		list_holder = this;
	}
	return * parser_list;
}

Parser * Parser::id(Control * c) const
{
	return 0;
}

void Parser::init_parser_list()
{
	if (Parser::parser.get_parser_list().size()) return;
	Parser::parser.get_parser_list().push_back(& parser::Automatch::parser_automatch);
	Parser::parser.get_parser_list().push_back(& parser::Board::parser_board);
	Parser::parser.get_parser_list().push_back(& parser::Decline::parser_decline);
	Parser::parser.get_parser_list().push_back(& parser::File::parser_file);
	Parser::parser.get_parser_list().push_back(& parser::GameInfo::parser_game_info);
	Parser::parser.get_parser_list().push_back(& parser::Kibitz::parser_kibitz);
	Parser::parser.get_parser_list().push_back(& parser::Match::parser_match);
	Parser::parser.get_parser_list().push_back(& parser::MatchStart::parser_match_start);
	Parser::parser.get_parser_list().push_back(& parser::Misc::parser_misc);
	Parser::parser.get_parser_list().push_back(& parser::Move::parser_move);
	Parser::parser.get_parser_list().push_back(& parser::PlayerInfo::parser_player_info);
	Parser::parser.get_parser_list().push_back(& parser::Prob::parser_prob);
	Parser::parser.get_parser_list().push_back(& parser::Prompt::parser_prompt);
	Parser::parser.get_parser_list().push_back(& parser::Results::parser_results);
	Parser::parser.get_parser_list().push_back(& parser::Say::parser_say);
	Parser::parser.get_parser_list().push_back(& parser::Stats::parser_stats);
	Parser::parser.get_parser_list().push_back(& parser::Stored::parser_stored);
}

Parser * Parser::search_id(Control * c)
{
	if (! parser_list) return 0;
	for (std::vector<Parser *>::const_iterator i = parser_list->begin(); i != parser_list->end(); i ++) {
		Parser * p = (* i)->id(c);
		if (p == * i) return 0; // processed and complete
		if (p) return p;
	}
	// std::cerr << "no parser for message: >" << c->get_line() << "<" << std::endl;

	if (go::settings.get_option(go::Settings::OPT_LEAK_RAW) && c->get_line().length()) { // no parser for the message, dump raw
		std::string s = "[RAW:";
		s += c->get_line() + ']';
		c->message_misc(s);
	}
	return 0;
}

Parser::Parser(Parser * p)
{
// 	std::cerr << "Parser loaded!" << std::endl;
	// get_parser_list().push_back(p);
}

Parser::Parser(Control * c)
{
	control = c;
}

Parser::~Parser()
{
	if (list_holder == this) delete parser_list;
}

bool Parser::process()
{
	return false;
}
