/* ccgo: igs/parser/move.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_PARSER_MOVE_HH
#define IGS_PARSER_MOVE_HH
#include "parser.hh"
#include "../../move.hh"
#include <vector>
namespace igs
{
	namespace parser
	{
		class Move :
			public Parser
		{
			int game_num;
			std::string w_name;
			int w_cap;
			int w_time;
			int w_mvs;
			std::string b_name;
			int b_cap;
			int b_time;
			int b_mvs;
			bool parser_head();
			Parser * id(Control *) const;
			int move_count;
		public:
			Move(Parser *);
			Move(Control *);
			~Move();
			bool process();
			static Move parser_move;
		};
	}
}
#endif // IGS_PARSER_MOVE_HH
