/* ccgo: igs/parser/move.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "move.hh"
#include "../../handicap.hh"
#include "../../put_move.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern Move parser_move;
Move Move::parser_move(& Move::parser_move);

Parser * Move::id(Control * c) const
{
	if (c->get_num_cmd() != 15) return 0;
	Move * m = new Move(c);
	if (m->parser_head()) {
		// std::cerr << "get move header" << std::endl;
		return m;
	}
	delete m;
	return 0;
}

bool Move::parser_head()
{
	std::istringstream d(control->get_cmd_dat());
	std::string t;
	d >> t;
	if (t != "Game") return false;
	game_num = -1;
	d >> game_num;
	if (game_num < 0) return false;
	if (d.get() != ' ' || d.get() != 'I' || d.get() != ':' || d.get() != ' ') return false;
	d >> w_name;
	if (d.get() != ' ' || d.get() != '(') return false;
	d >> w_cap >> w_time >> w_mvs;
	if (d.get() != ')') return false;
	d >> t;
	if (t != "vs" || d.get() != ' ') return false;
	d >> b_name;
	if (d.get() != ' ' || d.get() != '(') return false;
	d >> b_cap >> b_time >> b_mvs;
	if (d.get() != ')') return false;
	// control->game_time(game_num, w_time, w_mvs, b_time, b_mvs);
	move_count = 0;
	// std::cerr << "game move header: " << control->get_cmd_dat() << std::endl;
	return true;
}

Move::Move(Parser * p) :
	Parser(p)
{
	move_count = -1;
}

Move::Move(Control * c) :
	Parser(c)
{
	move_count = -1;
}

Move::~Move()
{
	if (move_count < 0)  return;
	control->game_time(game_num, w_time, w_mvs, b_time, b_mvs);
}

bool Move::process()
{
	if (control->get_num_cmd() != 15) {
		if (control->get_num_cmd() != 9) return false;
		if (control->get_cmd_dat().substr(0, 16) == "Game is titled: ") {
			control->game_title(game_num, control->get_cmd_dat().substr(16));
			return true;
		}
		if (control->get_cmd_dat() == "Handicap and komi are disable.") {
			return true;
		}
		return false;
	}
	std::istringstream s(control->get_cmd_dat());
	int mn = -1;
	s >> mn;
	if (mn < 0 || s.get() != '(') return false;
	char turn = s.get();
	if ((turn != 'B' && turn != 'W') || s.get() != ')' || s.get() != ':' || s.get() != ' ') return false;
	std::string ms;
	s >> ms;
	// std::cerr << "parsing move : " << ms << std::endl;
	go::Move * move;
	if (ms == "Pass") {
		move = new go::Move(turn == 'B' ? go::TURN_BLACK : go::TURN_WHITE);
	} else if (ms == "Handicap") {
		int h;
		s >> h;
		if (h < 2) return false;
		move = new go::Handicap(h);
	} else {
		if (ms.length() < 2) return false;
		go::Loc l(ms);
		if (! l) return false;
		move = new go::PutMove(turn == 'B' ? go::TURN_BLACK : go::TURN_WHITE, l);
		// pick up the list of killed stone from IGS server
		std::vector<go::Loc> kill_list;
		ms = "";
		s >> ms;
		while (ms.length() > 1) {
			kill_list.push_back(go::Loc(ms));
			ms = "";
			s >> ms;
		}
	}
	if (! move) return false;
	move->set_num(mn + 1);
	control->game_move(move, game_num);
	move_count ++;
	return true;
}
