/* ccgo: igs/parser/misc.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "misc.hh"
#include <sstream>
#include <iostream>

using namespace igs;
using namespace parser;
using namespace std;

// extern Misc parser_misc;
Misc Misc::parser_misc(& Misc::parser_misc);

Parser * Misc::id(Control * c) const
{
	int cmd = c->get_num_cmd();
	string dat = c->get_cmd_dat();
	string::size_type i = 0;
	string::size_type j = 0;
	switch (cmd) {
	case 0: // no cmd??
		if (c->get_line() == "#> ") { // oh oh! not in client mode...
			c->toggle_state(TOGGLE_CLIENT, false);
		} else return 0;
		break;
	case 5: // messages...
		// cerr << "cmd = 5" << endl;
		if (dat.substr(0, 28) == "Setting you open for matches") {
			c->toggle_state(TOGGLE_OPEN, true);
		} else if ((i = dat.find(" is not logged on")) != string::npos) {
			c->match_not_online(dat.substr(0, i));
		} else if (dat.substr(0, 46) == "That player is currently not accepting matches") {
			c->match_not_open();
		} else if ((i = dat.find(" is currently involved in a match")) != string::npos) {
			c->match_in_match(dat.substr(0, i));
		} else {
			c->message_misc(dat);
		}
		break;
	case 9: // ...
		if (dat.substr(0, 14) == "Removing game " && dat.find("from ob", 15) != string::npos) {
			int g = -1;
			istringstream(dat.substr(14)) >> g;
			if (g < 0) return 0;
			c->ob_remove(g);
		} else if (dat.substr(0, 6) == "{Game ") { // game results (observing/non-verbose)
			istringstream t(dat.substr(6));
			string d;
			t >> d;
			int g = -1;
			istringstream(d) >> g;
			if (g < 0) return 0;
			t >> d;
			t >> d;
			if (d != "vs") return 0;
			t >> d;

			string::size_type r = t.rdbuf()->in_avail();
			if (r < 2) return 0;
			r --;
			d = dat.substr(dat.size() - r, r);
			if ((r = d.find('}')) == string::npos) return 0;
			d = d.substr(0, r);
			if (d.find("has adjourned") != string::npos) c->game_finish(g, "adjourned");
			else if ((r = d.find(": ")) != string::npos) c->game_finish(g, d.substr(r + 2));
			else {
				cerr << "strange game result: " << dat << endl;
				c->game_finish(g, d);
			}
		} else if (dat.substr(0, 32) == "Adding game to observation list.") {
			// cerr << "adding game" << endl;
		} else if (dat.substr(0, 4) == "Set ") {
			istringstream t(dat.substr(4));

			string s;
			t >> s;
			ToggleType type;
			if (s == "bell") type = TOGGLE_BELL;
			else if (s == "quiet") type = TOGGLE_QUIET;
			else if (s == "shout") type = TOGGLE_SHOUT;
			else if (s == "automail") type = TOGGLE_AUTOMAIL;
			else if (s == "open") type = TOGGLE_OPEN;
			else if (s == "looking") type = TOGGLE_LOOKING;
			else if (s == "kibitz") type = TOGGLE_KIBITZ;
			else if (s == "chatter") type = TOGGLE_CHATTER;
			else if (s == "singlegame") type = TOGGLE_SINGLEGAME;
			else if (s == "verbose") type = TOGGLE_VERBOSE;
			else if (s == "client") type = TOGGLE_CLIENT;
			else return 0; // how can this be?

			t >> s; // "to"
			t >> s; // "be"
			t >> s;
			bool state = s == "True."; // or "False."
			c->toggle_state(type, state);
		} else if (dat.substr(0, 2) == "!!") { // system message
			c->message_sys(dat);
		} else if (dat.substr(0, 5) == "Game " && (i = dat.find(": ")) != string::npos) { // game results
			
			istringstream t(dat.substr(5));
			int g = -1;
			t >> g;
			if (g < 0) return 0;
			string d;
			t >> d >> d >> d >> d; // : white vs black
			int n = t.rdbuf()->in_avail();
			n --;
			if (n < 0) return 0;
			d = dat.substr(dat.size() - n);
			if (d.substr(0, 13) == "has adjourned") c->game_finish(g, "adjourned");
			else if (d.substr(0, 2) == ": ") c->game_finish(g, d.substr(2));
			else {
				cerr << "strange game result: " << dat << endl;
				c->game_finish(g, d);
			}
		} else if ((i = dat.find("You can check ")) != string::npos && dat.find("finished.", i)) {
			c->match_score();
		} else if (dat.find("Board is restored to ") != string::npos) {
			c->match_restore();
		} else if (dat.find("Game has been adjourned.") != string::npos) {
			c->match_adjourn();
		} else if ((i = dat.find("Removing @ ")) != string::npos) {
			i += 11;
			j = i + 1;
			while (j < dat.size()) {
				if (dat[j] > '9' && dat[j] < '0') break;
				j ++;
			}
			c->match_remove(go::Loc(dat.substr(i, j - i)));
		} else if (dat.find("Requesting match in ") != string::npos) {
			// match request sent
		} else if ((i = dat.find(" has resigned the game.")) != string::npos) {
			istringstream t(dat.substr(0, i));
			string s;
			t >> s;
			c->match_resign(s);
		} else if ((i = dat.find(" has run out of time.")) != string::npos) {
			istringstream t(dat.substr(0, i));
			string s;
			t >> s;			
			c->match_timeup(s);
		} else if (dat.substr(0, 18) == "Removed game file " && (i = dat.find(" from database.")) != string::npos) {
			string s = dat.substr(18, i - 18);
			if (! s.size()) return 0;
			i = 0;
			while (s[i] != '-') {
				i ++;
				if (i > s.size()) return 0;
			}
			c->remove_match(s.substr(0, i), s.substr(i + 1));
		} else if (dat.substr(0, 20) == "Setting your '.' to ") {
			// setting who to tell
		} else if (dat.substr(0, 11) == "Game saved.") {
			// adjourned match
		} else if (dat.substr(0, 15) == "game completed.") {
			// adjourned match
		} else if (dat.find(" has restarted your game.") != string::npos) {
			// restarting game
		} else if (dat.find(" has restored your old game.") != string::npos) { // what's the difference from the above??
			// restored game
		} else if (dat.find(" has typed done.") != string::npos) {
			// done in scoring
		} else if (dat.substr(0, 11) == "The player " && dat.find(" is now in byo-yomi.", 11) != string::npos) {
			// enter byo-yomi
		} else if (dat.substr(0, 9) == "You have " && (i = dat.find(" stones and ", 9)) != string::npos && dat.find(" minute", i) != string::npos) {
			// byo-yomi info
		} else if (dat == "Your opponent has lost his/her connection.") {
			// opponent gone
		} else if (dat.substr(0, 31) == "Game will count towards ratings") {
			c->match_message("free game => rated game");
		} else if (dat.substr(0, 35) == "Game will not count towards ratings") {
			c->match_message("rated game => free game");
		} else if (dat == "Your opponent requests an adjournment.") {
			// adjourn
		} else if (dat.substr(0, 24) == "Use <adjourn> to adjourn") {
			// adjourn
		} else {
			return 0;
		}
		break;
	case 19: // say
		if (dat[0] == '*' && (i = dat.find("*: ", 1)) != string::npos) {
			c->message_kibitz(0, dat);
		} else return 0;
		break;
	case 20: // match outcome, following a board
		if (dat.find("(W:O): ") != string::npos) {
			istringstream t(dat);
			string s;
			string w;
			string ws;
			string b;
			string bs;
			t >> w >> s >> ws >> s >> b >> s >> bs;
			ostringstream ss;
			ss <<  w << ' ' << ws << ' ' << b << ' ' << bs;
			c->match_finish(ss.str());
		} else return 0;
		break;
	case 21: // misc
		if (dat.substr(0, 7) == "{Match " && (i = dat.find(": ", 7)) != string::npos && (j = dat.find(" vs. ", i)) != string::npos) { // new game
			string s;
			istringstream t(dat.substr(7, i - 7));
			int g = - 1;
			t >> g;
			if (g < 0) return 0;
			Game gm;
			gm.set_num(g);
			t.str(dat.substr(i + 2));
			t.clear();
			t >> s;
			gm.set_white(s);

			t.str(dat.substr(j + 5));
			t.clear();
			t >> s;
			gm.set_black(s);
			gm.set_moves(0);

			i = dat.find(" [");
			if (i != string::npos) {
				gm.set_w_rank(Player::Rank(dat.substr(i + 2, 4)));
				i = dat.find(" [", i + 2);
				if (i != string::npos) gm.set_b_rank(Player::Rank(dat.substr(i + 2, 4)));
			}
			c->game_update(gm);
		} else if (dat.substr(0, 6) == "{Game " && (i = dat.find(": ", 6)) != string::npos && (j = dat.find(" vs ", i)) != string::npos) {
			if (dat.find(" @ Move ", j) != string::npos) { // resumed game
				istringstream t(dat.substr(6));
				string s;
				int g = - 1;
				t >> g;
				if (g < 0) return 0;
				Game gm;
				gm.set_num(g);
				t >> s; // ':'
				t >> s;
				gm.set_white(s);
				t >> s >> s;
				gm.set_black(s);
				t >> s >> s; // '@' 'Move"
				int n = - 1;
				t >> n;
				if (n < 0) return 0;
				gm.set_moves(n);
				c->game_update(gm);
			} else { // game result
				istringstream t(dat.substr(6));
				int g = - 1;
				t >> g;
				if (g < 0) return 0;
				i = dat.find(" ", j);
				if (i == string::npos) return 0;
				i ++;
				j = dat.find("}", i);
				if (j == string::npos) return 0;
				string s = dat.substr(i, j - i);
				if (s.find("has adjourned") != string::npos) c->game_finish(g, "adjourned");
				else if ((i = s.find(": ")) != string::npos) c->game_finish(g, s.substr(i + 2));
				else {
					cerr << "strange game result: " << dat << endl;
					c->game_finish(g, s);
				}
			}
		} else if (dat[0] == '{' && (i = dat.find("] has connected.", 2)) != string::npos) {
			j = dat.find(" [", 1);
			if (j == string::npos) return 0;
			c->player_update(dat.substr(1, j - 1), dat.substr(j + 2, i - j - 2));
		} else if (dat[0] == '{' && (i = dat.find(" has disconnected}", 1)) != string::npos) {
			c->player_remove(dat.substr(1, i - 1));
		} else if (dat.substr(0, 2) == "!!" && dat.find("!!: ", 2) != string::npos) {
			// system message
			// cerr << "[system message]" << dat << endl;
			c->message_sys(dat);
		} else if (dat[0] == '!' && dat.find("!: ", 1) != string::npos) {
			// yelling
			c->message_yell(dat);
		} else {
			return 0;
		}
		break;
	case 24: // tell
		if (dat[0] == '*' && (i = dat.find("*: ", 1)) != string::npos) {
			c->message_tell(dat);
			c->message_tell(dat.substr(1, i - 1), dat.substr(i + 3));
		} else return 0;
		break;
	case 28: // undo
		if ((i = dat.find("Undo in game ")) != string::npos) {
			istringstream t(dat.substr(i + 13));
			int g = -1;
			t >> g;
			if (g < 0) return 0;
			c->game_undo(g);
		} else if (dat.find(" undid the") != string::npos) {
			c->game_undo();
		} else {
			return 0;
		}
		break;
	case 40: // say recoil?
		break;
	case 48: //
		if ((i = dat.find("Game ")) == string::npos) return 0;
		if ((j = dat.find(" has been adjourned by ", i)) != string::npos) {
			istringstream t(dat.substr(i + 5, j - i - 5));
			int g = - 1;
			t >> g;
			if (g < 0) return 0;
			t.str(dat.substr(j + 23));
			t.clear();
			string s;
			t >> s;
			string ss("adjourned by ");
			ss += s;
			c->game_finish(g, ss);
		} else if (dat.find(" requests an adjournment", i) != string::npos) {
			istringstream t(dat.substr(i + 5));
			int g = -1;
			t >> g;
			if (g < 0) return 0;
			string s;
			t >> s;
			ostringstream os;
			os << '<' << s << " asks to adjourn>";
			c->match_message(os.str(), g);
		} else return 0;
		break;
	case 49:
		if ((i = dat.find("Game ")) != string::npos && (j = dat.find(" is removing @ ", i)) != string::npos) {
			istringstream t(dat.substr(i + 5));
			int g = -1;
			t >> g;
			if (g < 0) return 0;
			string s;
			t >> s; // who
			t >> s >> s >> s >> s; // "is removing @ "...
			c->match_remove(go::Loc(s), g);
		} else return 0;
		break;
	default:
		return 0;
	}
	// return & parser_misc;
	return (Parser *) this;
}

Misc::Misc(Parser * p) :
	Parser(p)
{
}

Misc::Misc(Control * c) :
	Parser(c)
{
}

Misc::~Misc()
{
}

bool Misc::process()
{
	return false;
}
