/* ccgo: igs/parser/match_start.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "match_start.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern MatchStart parser_match_start;
MatchStart MatchStart::parser_match_start(& MatchStart::parser_match_start);

Parser * MatchStart::id(Control * c) const
{
	if (c->get_num_cmd() != 9) return 0;
	MatchStart * ms = new MatchStart(c);
	if (ms->parse_head()) return ms;
	delete ms;
	return 0;
}

bool MatchStart::parse_head()
{
	std::istringstream s(control->get_cmd_dat());
	std::string d;
	s >> d;
	if (d == "Creating") {
		s >> d;
		if (d != "match") return false;
		accepted = false;
	} else {
		if (d != "Match") return false;
		accepted = true;
	}
	if (s.get() != ' ' || s.get() != '[') return false;
	s >> game;
	if (s.get() != ']') return false;
	s >> d >> d;
	if (d.length() < 1) return false;
	if (accepted) who = d;
	else who = d.substr(0, d.length() - 1);
	return true;
}

MatchStart::MatchStart(Parser * p) :
	Parser(p)
{
}

MatchStart::MatchStart(Control * c) :
	Parser(c)
{
	complete = false;
}

MatchStart::~MatchStart()
{
}

bool MatchStart::process()
{
	if (complete) return false;
	if (control->get_num_cmd() != 9) return false;
	control->match_create(game, who);
	complete = true;
	return true;
}
