/* ccgo: igs/parser/match.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "match.hh"
#include <sstream>

using namespace igs::parser;
// using namespace parser;

// extern Match parser_match;
Match Match::parser_match(& Match::parser_match);

igs::Parser * Match::id(Control * c) const
{
	if (c->get_num_cmd() != 9) return 0;
	if (c->get_cmd_dat().substr(0, 6) != "Match[") return 0;
	Match * m = new Match(c);
	return m;
}

Match::Match(Parser * p) :
	Parser(p)
{
}

Match::Match(Control * c) :
	Parser(c)
{
	complete = false;
}

Match::~Match()
{
}

bool Match::process()
{
	if (complete) return false;
	if (control->get_num_cmd() != 9) return 0;
	std::string d = control->get_cmd_dat();
	if (d.length() < 12) return 0;
	std::istringstream s(d.substr(11));
	s >> m.opponent;
	char t;
	s >> t;
	if (t == 'B') m.my_turn = go::TURN_BLACK;
	else if (t == 'W') m.my_turn = go::TURN_WHITE;
	else return 0;
	s >> m.board_size >> m.time >> m.byo_time;
	m.set_option = true;
	control->match_request(m);
	complete = true;
	return true;
}
