/* ccgo: igs/parser/kibitz.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "kibitz.hh"
#include <sstream>
#include <iostream>
using namespace igs;
using namespace parser;
using namespace std;

// extern Kibitz parser_kibitz;
Kibitz Kibitz::parser_kibitz(& Kibitz::parser_kibitz);

Parser * Kibitz::id(Control * c) const
{
	if (c->get_num_cmd() != 11) return 0;
	Kibitz * k = new Kibitz(c);
	if (k->parse_head()) return k;
	delete k;
	return 0;
}

bool Kibitz::parse_head()
{
	string s = control->get_cmd_dat();

	if (s.substr(0, 7) != "Kibitz ") return false;
	who = "";
	string::size_type i = 7;
	while (i < s.length() && s[i] != ' ') {
		who += s[i];
		i ++;
	}
	if (s.length() < i + 6 || s[i] != ' ' || s[i + 1] != '[') return false;
	i += 2;
	string::size_type j = i;
	while (j < s.length() && s[j] != ']') j ++;
	if (j >= s.length()) return false;

	rank = Player::Rank(s.substr(i, j - i));
	i = j + 1;
	if (s.substr(i, 7) != ": Game ") return false;
	i += 7;
	j = i;
	while (j < s.length() && s[j] != '[') j ++;
	if (j >= s.length()) return false;
	j ++;
	i = j;
	while (j < s.length() && s[j] != ']') j ++;
	if (j >= s.length()) return false;
	game = - 1;
	istringstream(s.substr(i, j - i)) >> game;
	if (game < 0) return false;
	return true;
}

Kibitz::Kibitz(Parser * p) :
	Parser(p)
{
}

Kibitz::Kibitz(Control * c) :
	Parser(c)
{
}

Kibitz::~Kibitz()
{
}

bool Kibitz::process()
{
	string s = control->get_line();
	if (s.substr(0, 6) != "11    ") return false;

	s = who + "[" + rank.get_text() + "]: " + s.substr(6);
	control->message_kibitz(game, s);
	return true;
}
