/* ccgo: igs/parser/init.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_PARSER_INIT_HH
#define IGS_PARSER_INIT_HH
#include "parser.hh"
#include "../login_dialog.hh"
namespace igs
{
	namespace parser
	{
		class Init :
			public Parser
		{
			enum Stage {
				STAGE_HEAD,
				STAGE_LOGIN,
				STAGE_PASS,
				STAGE_MOTD,
				STAGE_TEXT,
				STAGE_READY
			};
			Stage stage;
			std::string login_name;
			std::string password;
			bool tried_pass;
			LoginDialog * dialog;
			bool cancelled;
			std::string banner;
			std::string motd;
		public:
			Init(Control *);
			~Init();
			virtual bool process();
			void set_login(const std::string &, const std::string &);
			void cancel();
		};
	}
}
#endif // IGS_PARSER_LOGIN_HH
