/* ccgo: igs/parser/init.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "../../config.hh"
#include "../../gettext.h"
#include "init.hh"
#include <iostream>
#include "../../settings.hh"

#define _(String) Glib::locale_to_utf8(gettext(String))

using namespace igs;
using namespace parser;

Init::Init(Control * c) :
	Parser(c)
{
	stage = STAGE_HEAD;
	dialog = 0;
	cancelled = false;
	banner = "";
}

Init::~Init()
{
	// std::cerr << "deleting dialog" << std::endl;
	if (dialog) delete dialog;
}

bool Init::process()
{
	if (cancelled) return false;
	const std::string & s = control->get_line();
	if (s == "Login: " || s == "1 0") {
		if (stage == STAGE_HEAD) {
// 			std::cerr << "init add tagged" << std::endl;
			control->add_tagged_message(_("Login banner"), banner);
		}
		stage = STAGE_LOGIN;
// 		std::cerr << "login prompt" << std::endl;
		if (! tried_pass && login_name.length()) {
			control->send_line(login_name);
		} else {
			if (! dialog) dialog = new LoginDialog(this);
			dialog->show_all();
		}
	} else if (stage == STAGE_LOGIN && (s == "Password: " || s == "1 1")) {
// 		std::cerr << "send password" << std::endl;
		if (password.length()) control->send_line(password);
		else control->send_line(login_name);
		tried_pass = true;
		stage = STAGE_PASS;
	} else if (s == "#> ") { // text prompt, switch to client mode
		if (stage != STAGE_TEXT) {
			stage = STAGE_TEXT;
			std::cerr << "switching to client mode" << std::endl;
			control->send_line("toggle client 1");
			// TODO: check if verbose is 0 to start with, also verbose might be 1 even client == 1
			control->send_line("toggle verbose 0"); // should I wait for another prompt?
		}
	} else if (s == "9 File") { // motd
		if (stage == STAGE_MOTD) {
			stage = STAGE_PASS;
			control->add_tagged_message(_("MOTD"), motd);
		} else {
// 			std::cerr << "[message of the day]" << std::endl;
			stage = STAGE_MOTD;
			motd = "";
		}
	} else if (s == "1 5") { // good client prompt
		stage = STAGE_READY;
	} else if (s.substr(0, 1) == "{" || s.substr(0, 4) == "21 {") {
		// drop log messages during login
	}

	if (stage == STAGE_READY) {
		// std::cerr << "client ready!" << std::endl;
		// remember the login_name and password
		go::settings.set_string("default-name", login_name);
		go::settings.set_string("default-pass", password);
		control->add_message(".");
		control->set_username(login_name);		
		control->client_ready();
		return false;
	} else if (stage == STAGE_MOTD) {
		if (s != "9 File") {
			motd += "\n";
			motd += s;
		}
	} else if (stage == STAGE_HEAD) {
		banner += s;
		banner += "\n";
	} else {
		// std::cerr << ">" << s << "<" << std::endl;
	}
	return true;
}

void Init::set_login(const std::string & l, const std::string & p)
{
	login_name = l;
	password = p;
	tried_pass = false;
	if (stage == STAGE_LOGIN) {
// 		std::cerr << "login in, send login name: " << login_name << std::endl;
		control->send_line(login_name);
	}
}

void Init::cancel()
{
	control->cancel_conn();
}
