/* ccgo: igs/parser/game_info.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "game_info.hh"
#include "../game.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern GameInfo parser_game_info;
GameInfo GameInfo::parser_game_info(& GameInfo::parser_game_info);

Parser * GameInfo::id(Control * c) const
{
	if (c->get_num_cmd() != 7) return 0;
	if (c->get_cmd_dat().length() < 4) return 0;
	GameInfo * p = new GameInfo(c);
	if (c->get_cmd_dat().substr(0, 4) != "[##]") p->process();
	return p;
}

GameInfo::GameInfo(Parser * p) :
	Parser(p)
{
	control = 0;
}

GameInfo::GameInfo(Control * c) :
	Parser(c)
{
}

GameInfo::~GameInfo()
{
}

bool GameInfo::process()
{
	if (control->get_num_cmd() != 7) {
		control->game_end_update();
		return false;
	}
	Game g;
	if (! g.build(control->get_cmd_dat())) return false;
	control->game_update(g);
	return true;
}
