/* ccgo: igs/parser/file.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "file.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern File parser_file;
File File::parser_file(& File::parser_file);

Parser * File::id(Control * c) const
{
	if (c->get_line() != "8 File") return 0;
	File * k = new File(c);
	return k;
}

File::File(Parser * p) :
	Parser(p)
{
}

File::File(Control * c) :
	Parser(c)
{
	complete = false;
}

File::~File()
{
}

bool File::process()
{
	if (complete) return false;
	if (control->get_line() == "8 File") {
		control->file_text(text);
		complete = true;
		return true;
	}
	text += control->get_line() + "\n";
	return true;
}
