/* ccgo: igs/parser/decline.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "decline.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern Decline parser_decline;
Decline Decline::parser_decline(& Decline::parser_decline);

Parser * Decline::id(Control * c) const
{
	if (c->get_num_cmd() != 9) return 0;
	Decline * d = new Decline(c);
	if (d->parse_head()) return d;
	delete d;
	return 0;
}

bool Decline::parse_head()
{
	std::istringstream s(control->get_cmd_dat());
	std::string d;
	s >> who >> d;
	if (d != "declines") return false;
	s >> d;
	if (d != "your") return false;
	return true;
}

Decline::Decline(Parser * p) :
	Parser(p)
{
}

Decline::Decline(Control * c) :
	Parser(c)
{
	complete = false;
}

Decline::~Decline()
{
}

bool Decline::process()
{
	if (complete) return false;
	if (control->get_num_cmd() != 9) return false;
	control->match_decline(who);
	complete = true;
	return true;
}
