/* ccgo: igs/parser/board.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "board.hh"
#include <sstream>
#include <iostream>

using namespace igs::parser;

// extern Board parser_board;
Board Board::parser_board(& Board::parser_board);

igs::Parser * Board::id(Control * c) const
{
	if (c->get_num_cmd() != 22) return 0;
	Board * b = new Board(c);
	if (b->process()) return b;
	delete b;
	return 0;
}

Board::Board(Parser * p) :
	Parser(p)
{
}

Board::Board(Control * c) :
	Parser(c)
{
	line_count = -2;
	stage = 0;
}

Board::~Board()
{
}

bool Board::process()
{
	if (stage == 2) {
		if (control->get_num_cmd() != 13 && control->get_num_cmd() != 20) { // finished
			control->game_board(board);
			return false;
		}
		if (control->get_num_cmd() == 13) {
			board.is_score = false;
			if (control->get_cmd_dat().substr(0, 24) == "The date on the game is ") {
				board.date.set(control->get_cmd_dat().substr(24));
			} else {
				board.record.set(control->get_cmd_dat());
			}
		} else {
			board.is_score = true;
			board.score = control->get_cmd_dat();
		}
		return true;
	}
	if (control->get_num_cmd() != 22) return false;
	std::string d = control->get_cmd_dat();
	std::istringstream o(d);
	std::string r;
	char c;
	if (line_count < 0) { // starting
		if (line_count == -2) {
			o >> board.white;
			o >> r >> board.w_cap >> board.w_time >> board.w_stones;
			o >> c >> board.komi >> board.handicap;
			line_count = -1;
			return true;
		}
		o >> board.black;
		o >> r >> board.b_cap >> board.b_time >> board.b_stones;
		line_count = 0;
		return true;
	}
	int line;
	o >> line;
	if (line != line_count || o.get() != ':' || o.get() != ' ') {
		std::cerr << "board error" << std::endl;
		return false;
	}
	o >> r;
	if (line_count == 0) board.set_size(r.length());
	for (int i = 0; i < board.board_size; i ++) board.site(line_count, board.board_size - i - 1) = int(r[i] - '0');
	line_count ++;
	if (line_count == board.board_size) stage = 2;
// 	if (line_count == board.board_size) {
// 		control->game_board(board);
// 		complete = true;
// 	}
	return true;
}
