/* ccgo: igs/parser/automatch.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "automatch.hh"
#include <sstream>

using namespace igs;
using namespace parser;

// extern Automatch parser_automatch;
Automatch Automatch::parser_automatch(& Automatch::parser_automatch);

Parser * Automatch::id(Control * c) const
{
	if (c->get_num_cmd() != 36) return 0;
	Automatch * a = new Automatch(c);
	return a;
}

Automatch::Automatch(Parser * p) :
	Parser(p)
{
}

Automatch::Automatch(Control * c) :
	Parser(c)
{
	complete = false;
}

Automatch::~Automatch()
{
}

bool Automatch::process()
{
	if (complete) return false;
	if (control->get_num_cmd() != 36) return false;
	std::istringstream s(control->get_cmd_dat());
	std::string d;
	if (m.get_automatch()) {
		s >> d >> d;
		if (d != "accept") return false;
		control->match_request(m);
		complete = true;
		return true;
	}
	s >> m.opponent;
	s >> d;
	if (d != "wants") return false;
	s >> m.board_size;
	s.get();
	s >> d >> d >> m.time;
	s >> d >> d >> m.byo_time;
	s >> d >> d >> m.byo_stone;
	m.set_option = true;
	m.set_automatch(true);
	return true;
}
