/* ccgo: igs/match_win.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "match_win.hh"
#include "../settings.hh"
#include <gtkmm/label.h>

using namespace igs;

void MatchWin::on_hide()
{
	int n;
	while ((n = match_book.get_current_page()) >= 0) {
		MatchBox * m = (MatchBox *) match_book.get_nth_page(n);
		m->match_cancel(m);
	}
	Gtk::Window::on_hide();
}

MatchWin::MatchWin()
{
	set_title("igs Match List");

	std::string ip = go::settings.get_image_path();
	if (Glib::file_test(ip + "/matchlist_icon.png", Glib::FILE_TEST_EXISTS)) {
		set_icon(Gdk::Pixbuf::create_from_file(ip + "/matchlist_icon.png"));
	}

	Gtk::VBox * vb = Gtk::manage(new Gtk::VBox);
	add(* vb);

	Gtk::Label * lb = Gtk::manage(new Gtk::Label("Matches"));
	vb->pack_start(* lb, Gtk::PACK_SHRINK);
	vb->pack_start(match_book, Gtk::PACK_SHRINK);
	show_all_children();
}

MatchWin::~MatchWin()
{
	// std::cerr << "deleting MatchWin" << std::endl;
}

void MatchWin::add_match(MatchBox * mb, const std::string & t)
{
	match_book.prepend_page(* mb, t);
	match_book.set_current_page(0);
	present();
}

void MatchWin::del_match(MatchBox * mb)
{
	match_book.remove_page(* mb);
	if (match_book.get_current_page() < 0) hide();
}

void MatchWin::raise(MatchBox * mb)
{
	int n = match_book.page_num(* mb);
	if (n < 0) return;
	match_book.set_current_page(n);
	present();
}
