/* ccgo: igs/match_box.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_MATCH_BOX_HH
#define IGS_MATCH_BOX_HH
#include <gtkmm/box.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/optionmenu.h>
#include <gtkmm/table.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/label.h>
#include <gtkmm/checkbutton.h>
#include "match.hh"
namespace igs
{
	class MatchBox :
		public Gtk::Table
	{
		void send_match();
		Match match;
		Gtk::Label head_line;
// 		Gtk::VBox option_area;
		Gtk::HButtonBox button_area;

//		Gtk::CheckButton auto_match;

		Gtk::CheckButton set_option;
		void set_option_toggle();

		Gtk::VBox option_box;
		Gtk::OptionMenu my_turn;
		Gtk::Adjustment * board_size;
		Gtk::Adjustment * time;
		Gtk::Adjustment * byo_time;
		bool load_defs; // load defs from first turn on set_option
		Gtk::Button decline_button;
		void decline_match();
	public:
		MatchBox(const std::string &);
		~MatchBox();
		void update(const Match &); // should just ignore...
		void decline();
		void not_online();
		void not_open();
		void in_match();
		sigc::signal<void, MatchBox *> match_cancel;
		sigc::signal<void, const Match &> match_request;
	};
}
#endif // IGS_MATCH_BOX_HH
