/* ccgo: igs/login_dialog.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "../config.hh"
#include "../gettext.h"
#include "login_dialog.hh"
#include "../settings.hh"
#include <gtkmm/stock.h>

#define _(String) Glib::locale_to_utf8(gettext(String))

using namespace igs;

void LoginDialog::on_response(int r)
{
	switch (r) {
	case 0:
		hide();
		init->cancel();
		break;
	case 1:
		hide();
		init->set_login(name.get_text(), pass.get_text());
		break;
	default:
		break;
	}
}

LoginDialog::LoginDialog(parser::Init * i) :
	Dialog(_("Login to IGS")),
	init(i)
{
	Gtk::HBox * hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	hb->pack_start(* Gtk::manage(new Gtk::Label(_("Login") + ": ")), Gtk::PACK_SHRINK);
	hb->pack_start(name);
	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	hb->pack_start(* Gtk::manage(new Gtk::Label(_("Password") + ": ")), Gtk::PACK_SHRINK);
	hb->pack_start(pass);
	pass.set_visibility(false);
	add_button(Gtk::Stock::CANCEL, 0);
	add_button(Gtk::Stock::OK, 1);

	name.set_text(go::settings.get_string("default-name"));
	pass.set_text(go::settings.get_string("default-pass"));
}

LoginDialog::~LoginDialog()
{
	// std::cerr << "deleting login dialog" << std::endl;
}
