/* ccgo: igs/line_box.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "line_box.hh"

using namespace igs;

bool LineBox::on_key_press_event(GdkEventKey * e)
{
	switch (e->keyval) {
	case GDK_Up:
		if (ri == hist.rend()) break;
		if (ri == hist.rbegin()) current_line = get_text();
		set_text(* ri);
		++ ri;
		break;
	case GDK_Down:
		if (ri == hist.rbegin()) break;
		-- ri;
		if (ri == hist.rbegin()) set_text(current_line);
		else set_text(* (ri - 1));
		break;
	default:
		return Gtk::Entry::on_key_press_event(e);
	}
	return true;
}

void LineBox::on_activate()
{
	Gtk::Entry::on_activate();
	hist.push_back(get_text());
	if (hist.size() > 100) hist.erase(hist.begin());
	for (std::vector<std::string>::iterator i = hist.begin(); i + 1 != hist.end(); i ++) if (* i == hist.back()) {
		hist.erase(i);
		break;
	}
	ri = hist.rbegin();
	current_line = "";
	set_text(current_line);
}

LineBox::LineBox()
{
	ri = hist.rbegin();
}

void LineBox::clear_history()
{
	hist.clear();
	ri = hist.rbegin();
}

const std::string & LineBox::get_line()
{
	if (hist.size()) return hist.back();
	else return current_line;
}
