/* ccgo: igs/game_list.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_GAME_LIST_HH
#define IGS_GAME_LIST_HH
#include "game.hh"
#include "show.hh"
#include "board.hh"
#include <gtkmm/window.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <vector>
namespace igs
{
	class GameList :
		public Gtk::Window
	{
		std::string name;
		Gtk::Label n_games;
		void update_n_games();

		Gtk::TreeView view;
		class ModelCol :
			public Gtk::TreeModel::ColumnRecord
		{
		public:
			ModelCol();
			Gtk::TreeModelColumn<int> num;
			Gtk::TreeModelColumn<std::string> white;
			Gtk::TreeModelColumn<void *> w_rank;
			Gtk::TreeModelColumn<std::string> black;
			Gtk::TreeModelColumn<void *> b_rank;
		};
		ModelCol m_col;
		Glib::RefPtr<Gtk::ListStore> store;
		bool sort_toggle;
		Gtk::TreeView::Column * sort_col;
		Gtk::SortType sort_type;
		void sort_by(Gtk::TreeView::Column *);
		void select_game(const Gtk::TreeModel::Path &, Gtk::TreeViewColumn *);
		void close_show(Show *);
		enum GameState {
			GS_NORMAL = 0,
			GS_NEED_WIN,
			GS_CLOSE
		};
		struct Record
		{
			Game game;
			GameState state;
			Show * show;
			Gtk::TreeModel::Children::iterator iter;
			time_t stamp;
			bool scoring;
		};
		std::vector<Record> list;
		CustomText::CellRenderer w_render;
		CustomText::CellRenderer b_render;

		void refresh_request();
		time_t refresh_time;
		int my_match;

		int my_width;
		int my_height;
		void on_size_allocate(Gtk::Allocation &);
	public:
		GameList();
		~GameList();
		void set_name(const std::string &);
		void update(const Game &);
		void end_update();
		sigc::signal<void, int> miss_game;
		sigc::signal<void, int> skip_move;
		sigc::signal<void, int> close_game;
		sigc::signal<void, int> game_selected;
		void add_move(int, go::Move *);
		void undo_move(int);
		void sync_time(int, int, int, int, int);
		void add_title(int, const std::string &);

		void unob_game(int);
		void end_game(int, const std::string &);
		void msg_game(int, const std::string &);

		void game_score(int);
		void game_restore(int);
		void game_remove(int, const go::Loc &);
		void game_adjourn(int);
		void game_board(const Board &);

		void match_resign(const std::string &);
		void match_timeup(const std::string &);
		void remove_match(const std::string &, const std::string &);

		sigc::signal<void, const std::string &, TalkType, int> game_input_kibitz;

		sigc::signal<void, unsigned, int> game_input_handicap;
		sigc::signal<void, const go::Loc &, unsigned, int> game_input_put;
		sigc::signal<void, unsigned, int> game_input_pass;
		sigc::signal<void, int> game_input_undo;
		sigc::signal<void, const go::Loc &, int> game_input_terri;
		sigc::signal<void, int> game_input_reset;
		sigc::signal<void, int> game_input_done;

		sigc::signal<void, int> game_input_adjourn;
		sigc::signal<void, int> game_input_resign;

		sigc::signal<void> refresh_list;

		void wish_select_game(int);
	};
}
#endif // IGS_GAME_LIST_HH
