/* ccgo: igs/game.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_GAME_HH
#define IGS_GAME_HH
#include "player.hh"
#include <string>
#include <sigc++/object.h>
namespace igs
{
	class Game :
		public sigc::trackable
	{
		int num;
		std::string white;
		Player::Rank w_rank;
		std::string black;
		Player::Rank b_rank;
		int moves;
		int board_size;
		int handicap;
		double komi;
		int byo_time;
		int byo_move;
		char free;
		char rule;
		int observers;
		bool game_ok;
	public:
		Game();
		~Game();
		operator bool() const;
		bool build(const std::string &);
		int get_num() const;
		void set_num(int);
		const std::string & get_white() const;
		void set_white(const std::string &);
		const Player::Rank & get_w_rank() const;
		void set_w_rank(const Player::Rank &);
		const std::string & get_black() const;
		void set_black(const std::string &);
		const Player::Rank & get_b_rank() const;
		void set_b_rank(const Player::Rank &);
		int get_moves() const;
		void set_moves(int);
		int get_board_size() const;
		void set_board_size(int);
		double get_komi() const;
		int get_byo_time() const;
	};
}
#endif // IGS_GAME_HH
