/* ccgo: igs/game.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "game.hh"
#include <sstream>

using namespace igs;

Game::Game()
{
	game_ok = false;
}

Game::~Game()
{
}

Game::operator bool() const
{
	return game_ok;
}

bool Game::build(const std::string & dat)
{
	std::istringstream s(dat);
	if (s.get() != '[') return false;
	num = -1;
	s >> num;
	if (num < 0) return false;
	if (s.get() != ']') return false;
	s >> white;
	while (s.peek() == ' ') s.get();
	if (s.get() != '[') return false;
	char c;
	std::string srank;
	while (! s.eof() && (c = s.get()) != ']') {
		srank += c;
	}
	if (srank == "") return false;
	if (! w_rank.build(srank)) return false;
	std::string vs;
	s >> vs;
	if (vs != "vs.") return false;
	s >> black;
	while (s.peek() == ' ') s.get();
	if (s.get() != '[') return false;
	srank = "";
	while (! s.eof() && (c = s.get()) != ']') {
		srank += c;
	}
	if (srank == "") return false;
	if (! b_rank.build(srank)) return false;
	while (s.peek() == ' ') s.get();
	if (s.get() != '(') return false;
	s >> moves >> board_size >> handicap >> komi >> byo_time;
	byo_move = 0;
	if (s.get() != ' ') return false;
	free = s.get();
	rule = s.get();
	if (s.get() != ')' || s.get() != ' ' || s.get() != '(') return false;
	s >> observers;
	if (s.get() != ')') return false;
// 	std::cerr << "game built" << std::endl;
	return true;
}

int Game::get_num() const
{
	return num;
}

void Game::set_num(int n)
{
	num = n;
}

const std::string & Game::get_white() const
{
	return white;
}

void Game::set_white(const std::string & n)
{
	white = n;
}

const Player::Rank & Game::get_w_rank() const
{
	return w_rank;
}

void Game::set_w_rank(const Player::Rank & r)
{
	w_rank = r;
}

const std::string & Game::get_black() const
{
	return black;
}

void Game::set_black(const std::string & n)
{
	black = n;
}

const Player::Rank & Game::get_b_rank() const
{
	return b_rank;
}

void Game::set_b_rank(const Player::Rank & r)
{
	b_rank = r;
}

int Game::get_moves() const
{
	return moves;
}

void Game::set_moves(int n)
{
	moves = n;
}

int Game::get_board_size() const
{
	return board_size;
}

double Game::get_komi() const
{
	return komi;
}

int Game::get_byo_time() const
{
	return byo_time;
}
