/* ccgo: igs/fork.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_FORK_HH
#define IGS_FORK_HH
#include "connect.hh"
#include <glibmm.h>
#include <string>
namespace igs
{
	class Fork :
		virtual public Connect
	{
		int to_child;     // file handle to send message to child
		int from_child; // file handle to read from child
		pid_t child_pid; // pid of the child process

		sigc::connection grab_line_connection;
		bool grab_line(Glib::IOCondition);
		bool read_buffer();

		sigc::connection time_up_connection;
		bool time_up();
		int idle_time;  // idle time after last read

	protected:
		std::string line_buffer;
	public:
		Fork(const std::string &);
		virtual ~Fork();
		virtual void send_line(const std::string &);

		bool open_conn(const std::string &);
		void close_conn();
	};
}
#endif // IGS_FORK_HH
