/* ccgo: igs/encode.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "../config.hh"
#include "../gettext.h"
#include "encode.hh"
#include <glibmm/convert.h>

#define _(String) Glib::locale_to_utf8(gettext(String))

using namespace igs;

Glib::ustring igs::auto_convert(const std::string & s)
{
	Glib::ustring u = s;
	if (u.validate()) return u;
	u =_("[unknown encoding]");
	static const char * try_encoding[] = {"BIG5", "SJIS", "GB2312", "EUC-JP", 0};
	int i = 0;
	const char * c = 0;
	unsigned len = s.length();
	while (try_encoding[i]) {
		bool ok = false;
		Glib::ustring uu;
		try {
			uu = Glib::convert(s, "UTF-8", try_encoding[i]);
			ok = true;
		} catch (Glib::ConvertError e) {
			ok = false;
		}
		if (ok && uu.length() < len) {
			u = uu;
			len = uu.length();
			c = try_encoding[i];
		}
		i ++;
	}
	if (c) {
		// std::cerr << c << " string found" << std::endl;
	}
	return u;
}
